/*
 * Executor.java
 *
 * Created on 4. Januar 2007, 14:19
 */
/*
 * Copyright 2006 Schlichtherle IT Services
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.schlichtherle.io;

/**
 * Creates cancellable tasks.
 * This interface implements a subset of the functionality in JSE5's
 * <code>ExecutorService</code> interface,
 * which enables to backport the functionality to J2SE 1.4 easily.
 *
 * @author Christian Schlichtherle
 * @version @version@
 * @since TrueZIP 6.5
 */
interface Executor {

    /**
     * Returns a cancellable <code>Task</code> for the given
     * <code>target</code>.
     */
    Task submit(Runnable target);
}