/* The following code was generated by JFlex 1.4.3 on 14/04/15 14:51 */

/*
 * Copyright (c) 2006-2013 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Bogdan Stefanescu
 *     Florent Guillaume
 */
package org.nuxeo.ecm.core.query.sql.parser;

import java_cup.runtime.*;
import org.nuxeo.ecm.core.query.*;

/**
 * Lexer for NXQL
 */


public class Scanner implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING = 4;
  public static final int ES_HINT = 6;
  public static final int YYINITIAL = 0;
  public static final int SQ_STRING = 2;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3, 3
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\2\1\0\1\3\1\1\22\0\1\65\1\77\1\105"+
    "\1\0\1\4\2\0\1\106\1\102\1\103\1\13\1\17\1\104\1\20"+
    "\1\7\1\10\1\14\11\15\1\5\1\22\1\100\1\76\1\101\2\22"+
    "\1\47\1\63\1\26\1\53\1\24\1\33\1\72\1\44\1\55\1\6"+
    "\1\61\1\25\1\36\1\51\1\35\1\70\1\6\1\34\1\23\1\27"+
    "\1\57\1\74\1\43\1\110\1\66\1\112\1\11\1\107\1\12\1\22"+
    "\1\6\1\0\1\50\1\64\1\31\1\54\1\16\1\42\1\73\1\45"+
    "\1\56\1\6\1\62\1\30\1\41\1\52\1\40\1\71\1\6\1\37"+
    "\1\21\1\32\1\60\1\75\1\46\1\111\1\67\1\113\47\0\4\4"+
    "\4\0\1\4\12\0\1\4\4\0\1\4\5\0\27\4\1\0\37\4"+
    "\1\0\u01ca\4\4\0\14\4\16\0\5\4\7\0\1\4\1\0\1\4"+
    "\201\0\5\4\1\0\2\4\2\0\4\4\10\0\1\4\1\0\3\4"+
    "\1\0\1\4\1\0\24\4\1\0\123\4\1\0\213\4\10\0\236\4"+
    "\11\0\46\4\2\0\1\4\7\0\47\4\7\0\1\4\100\0\33\4"+
    "\5\0\3\4\30\0\1\4\24\0\53\4\43\0\2\4\1\0\143\4"+
    "\1\0\1\4\17\0\2\4\7\0\2\4\12\0\3\4\2\0\1\4"+
    "\20\0\1\4\1\0\36\4\35\0\131\4\13\0\1\4\30\0\41\4"+
    "\11\0\2\4\4\0\1\4\5\0\26\4\4\0\1\4\11\0\1\4"+
    "\3\0\1\4\27\0\31\4\107\0\1\4\1\0\13\4\127\0\66\4"+
    "\3\0\1\4\22\0\1\4\7\0\12\4\17\0\7\4\1\0\7\4"+
    "\5\0\10\4\2\0\2\4\2\0\26\4\1\0\7\4\1\0\1\4"+
    "\3\0\4\4\3\0\1\4\20\0\1\4\15\0\2\4\1\0\3\4"+
    "\16\0\4\4\7\0\1\4\11\0\6\4\4\0\2\4\2\0\26\4"+
    "\1\0\7\4\1\0\2\4\1\0\2\4\1\0\2\4\37\0\4\4"+
    "\1\0\1\4\23\0\3\4\20\0\11\4\1\0\3\4\1\0\26\4"+
    "\1\0\7\4\1\0\2\4\1\0\5\4\3\0\1\4\22\0\1\4"+
    "\17\0\2\4\17\0\1\4\23\0\10\4\2\0\2\4\2\0\26\4"+
    "\1\0\7\4\1\0\2\4\1\0\5\4\3\0\1\4\36\0\2\4"+
    "\1\0\3\4\17\0\1\4\21\0\1\4\1\0\6\4\3\0\3\4"+
    "\1\0\4\4\3\0\2\4\1\0\1\4\1\0\2\4\3\0\2\4"+
    "\3\0\3\4\3\0\14\4\26\0\1\4\50\0\1\4\13\0\10\4"+
    "\1\0\3\4\1\0\27\4\1\0\12\4\1\0\5\4\3\0\1\4"+
    "\32\0\2\4\6\0\2\4\43\0\10\4\1\0\3\4\1\0\27\4"+
    "\1\0\12\4\1\0\5\4\3\0\1\4\40\0\1\4\1\0\2\4"+
    "\17\0\2\4\22\0\10\4\1\0\3\4\1\0\51\4\2\0\1\4"+
    "\20\0\1\4\21\0\2\4\30\0\6\4\5\0\22\4\3\0\30\4"+
    "\1\0\11\4\1\0\1\4\2\0\7\4\72\0\60\4\1\0\2\4"+
    "\13\0\10\4\72\0\2\4\1\0\1\4\2\0\2\4\1\0\1\4"+
    "\2\0\1\4\6\0\4\4\1\0\7\4\1\0\3\4\1\0\1\4"+
    "\1\0\1\4\2\0\2\4\1\0\4\4\1\0\2\4\11\0\1\4"+
    "\2\0\5\4\1\0\1\4\25\0\4\4\40\0\1\4\77\0\10\4"+
    "\1\0\44\4\33\0\5\4\163\0\53\4\24\0\1\4\20\0\6\4"+
    "\4\0\4\4\3\0\1\4\3\0\2\4\7\0\3\4\4\0\15\4"+
    "\14\0\1\4\21\0\46\4\1\0\1\4\5\0\1\4\2\0\53\4"+
    "\1\0\u014d\4\1\0\4\4\2\0\7\4\1\0\1\4\1\0\4\4"+
    "\2\0\51\4\1\0\4\4\2\0\41\4\1\0\4\4\2\0\7\4"+
    "\1\0\1\4\1\0\4\4\2\0\17\4\1\0\71\4\1\0\4\4"+
    "\2\0\103\4\45\0\20\4\20\0\125\4\14\0\u026c\4\2\0\21\4"+
    "\1\0\32\4\5\0\113\4\3\0\3\4\17\0\15\4\1\0\4\4"+
    "\16\0\22\4\16\0\22\4\16\0\15\4\1\0\3\4\17\0\64\4"+
    "\43\0\1\4\3\0\2\4\103\0\130\4\10\0\51\4\1\0\1\4"+
    "\5\0\106\4\12\0\35\4\63\0\36\4\2\0\5\4\13\0\54\4"+
    "\25\0\7\4\70\0\27\4\11\0\65\4\122\0\1\4\135\0\57\4"+
    "\21\0\7\4\67\0\36\4\15\0\2\4\12\0\54\4\32\0\44\4"+
    "\51\0\3\4\12\0\44\4\153\0\4\4\1\0\4\4\3\0\2\4"+
    "\11\0\300\4\100\0\u0116\4\2\0\6\4\2\0\46\4\2\0\6\4"+
    "\2\0\10\4\1\0\1\4\1\0\1\4\1\0\1\4\1\0\37\4"+
    "\2\0\65\4\1\0\7\4\1\0\1\4\3\0\3\4\1\0\7\4"+
    "\3\0\4\4\2\0\6\4\4\0\15\4\5\0\3\4\1\0\7\4"+
    "\102\0\2\4\23\0\1\4\34\0\1\4\15\0\1\4\20\0\15\4"+
    "\3\0\33\4\107\0\1\4\4\0\1\4\2\0\12\4\1\0\1\4"+
    "\3\0\5\4\6\0\1\4\1\0\1\4\1\0\1\4\1\0\4\4"+
    "\1\0\13\4\2\0\4\4\5\0\5\4\4\0\1\4\21\0\51\4"+
    "\u0a77\0\57\4\1\0\57\4\1\0\205\4\6\0\4\4\3\0\2\4"+
    "\14\0\46\4\1\0\1\4\5\0\1\4\2\0\70\4\7\0\1\4"+
    "\20\0\27\4\11\0\7\4\1\0\7\4\1\0\7\4\1\0\7\4"+
    "\1\0\7\4\1\0\7\4\1\0\7\4\1\0\7\4\120\0\1\4"+
    "\u01d5\0\3\4\31\0\11\4\7\0\5\4\2\0\5\4\4\0\126\4"+
    "\6\0\3\4\1\0\132\4\1\0\4\4\5\0\51\4\3\0\136\4"+
    "\21\0\33\4\65\0\20\4\u0200\0\u19b6\4\112\0\u51cd\4\63\0\u048d\4"+
    "\103\0\56\4\2\0\u010d\4\3\0\20\4\12\0\2\4\24\0\57\4"+
    "\20\0\31\4\10\0\120\4\47\0\11\4\2\0\147\4\2\0\4\4"+
    "\1\0\4\4\14\0\13\4\115\0\12\4\1\0\3\4\1\0\4\4"+
    "\1\0\27\4\25\0\1\4\7\0\64\4\16\0\62\4\76\0\6\4"+
    "\3\0\1\4\16\0\34\4\12\0\27\4\31\0\35\4\7\0\57\4"+
    "\34\0\1\4\60\0\51\4\27\0\3\4\1\0\10\4\24\0\27\4"+
    "\3\0\1\4\5\0\60\4\1\0\1\4\3\0\2\4\2\0\5\4"+
    "\2\0\1\4\1\0\1\4\30\0\3\4\2\0\13\4\7\0\3\4"+
    "\14\0\6\4\2\0\6\4\2\0\6\4\11\0\7\4\1\0\7\4"+
    "\221\0\43\4\35\0\u2ba4\4\14\0\27\4\4\0\61\4\u2104\0\u016e\4"+
    "\2\0\152\4\46\0\7\4\14\0\5\4\5\0\1\4\1\0\12\4"+
    "\1\0\15\4\1\0\5\4\1\0\1\4\1\0\2\4\1\0\2\4"+
    "\1\0\154\4\41\0\u016b\4\22\0\100\4\2\0\66\4\50\0\15\4"+
    "\66\0\2\4\30\0\3\4\31\0\1\4\6\0\5\4\1\0\207\4"+
    "\7\0\1\4\34\0\32\4\4\0\1\4\1\0\32\4\13\0\131\4"+
    "\3\0\6\4\2\0\6\4\2\0\6\4\2\0\3\4\3\0\2\4"+
    "\3\0\2\4\31\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\1\1\2\2\1\3\1\1\1\4\1\5\2\6"+
    "\1\7\1\10\32\3\1\11\1\1\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\21"+
    "\1\24\1\23\1\25\1\1\6\25\1\3\1\0\1\26"+
    "\1\0\1\26\1\0\21\3\2\27\1\3\1\27\4\3"+
    "\2\30\16\3\1\31\1\3\1\32\6\3\1\33\1\34"+
    "\1\35\1\36\1\37\1\40\1\41\1\23\1\42\1\43"+
    "\6\25\1\44\4\45\1\0\1\26\1\0\33\3\1\46"+
    "\1\47\1\50\1\51\17\3\6\25\1\44\2\0\10\3"+
    "\1\52\3\3\1\53\1\3\1\54\11\3\1\55\1\56"+
    "\1\57\11\3\6\25\4\0\7\3\1\60\7\3\1\61"+
    "\4\3\1\62\5\3\4\25\1\63\1\64\1\65\7\3"+
    "\1\66\3\0\1\67\4\3\3\0\4\25\6\3\2\0"+
    "\2\3\1\70\2\0\4\25\2\3\1\71\2\3\1\72"+
    "\1\73\1\74\1\75\1\76\2\3\1\77\1\100";

  private static int [] zzUnpackAction() {
    int [] result = new int[332];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\114\0\230\0\344\0\u0130\0\u017c\0\u0130\0\u01c8"+
    "\0\u0214\0\u0260\0\u0130\0\u02ac\0\u02f8\0\u0130\0\u0130\0\u0344"+
    "\0\u0390\0\u03dc\0\u0428\0\u0474\0\u04c0\0\u050c\0\u0558\0\u05a4"+
    "\0\u05f0\0\u063c\0\u0688\0\u06d4\0\u0720\0\u076c\0\u07b8\0\u0804"+
    "\0\u0850\0\u089c\0\u08e8\0\u0934\0\u0980\0\u09cc\0\u0a18\0\u0a64"+
    "\0\u0ab0\0\u0130\0\u0afc\0\u0b48\0\u0b94\0\u0130\0\u0130\0\u0130"+
    "\0\u0130\0\u0130\0\u0be0\0\u0130\0\u0c2c\0\u0c78\0\u0130\0\u0cc4"+
    "\0\u0d10\0\u0d5c\0\u0da8\0\u0df4\0\u0e40\0\u0e8c\0\u0ed8\0\u0f24"+
    "\0\u0f70\0\u0fbc\0\u1008\0\u1054\0\u02ac\0\u10a0\0\u10ec\0\u1138"+
    "\0\u1184\0\u11d0\0\u121c\0\u1268\0\u12b4\0\u1300\0\u134c\0\u1398"+
    "\0\u13e4\0\u1430\0\u147c\0\u14c8\0\u1514\0\u1560\0\u15ac\0\u15f8"+
    "\0\u1644\0\u1690\0\u16dc\0\u1728\0\u1774\0\u17c0\0\u180c\0\u1858"+
    "\0\u18a4\0\u18f0\0\u193c\0\u1988\0\u19d4\0\u1a20\0\u1a6c\0\u1ab8"+
    "\0\u1b04\0\u1b50\0\u1b9c\0\u1be8\0\u1c34\0\u1c80\0\u1ccc\0\u01c8"+
    "\0\u1d18\0\u01c8\0\u1d64\0\u1db0\0\u1dfc\0\u1e48\0\u1e94\0\u1ee0"+
    "\0\u0130\0\u0130\0\u0130\0\u0130\0\u0130\0\u0130\0\u0130\0\u0130"+
    "\0\u0130\0\u0130\0\u1f2c\0\u1f78\0\u1fc4\0\u2010\0\u205c\0\u20a8"+
    "\0\u20f4\0\u2140\0\u218c\0\u21d8\0\u2224\0\u2270\0\u22bc\0\u22bc"+
    "\0\u2308\0\u2354\0\u23a0\0\u23ec\0\u2438\0\u2484\0\u24d0\0\u251c"+
    "\0\u2568\0\u25b4\0\u2600\0\u264c\0\u2698\0\u26e4\0\u2730\0\u277c"+
    "\0\u27c8\0\u2814\0\u2860\0\u28ac\0\u28f8\0\u2944\0\u2990\0\u29dc"+
    "\0\u2a28\0\u2a74\0\u2ac0\0\u01c8\0\u01c8\0\u01c8\0\u01c8\0\u2b0c"+
    "\0\u2b58\0\u2ba4\0\u2bf0\0\u2c3c\0\u2c88\0\u2cd4\0\u2d20\0\u2d6c"+
    "\0\u2db8\0\u2e04\0\u2e50\0\u2e9c\0\u2ee8\0\u2f34\0\u2f80\0\u2fcc"+
    "\0\u3018\0\u3064\0\u30b0\0\u30fc\0\u3148\0\u3194\0\u31e0\0\u322c"+
    "\0\u3278\0\u32c4\0\u3310\0\u335c\0\u33a8\0\u33f4\0\u3440\0\u01c8"+
    "\0\u348c\0\u34d8\0\u3524\0\u01c8\0\u3570\0\u01c8\0\u35bc\0\u3608"+
    "\0\u3654\0\u36a0\0\u36ec\0\u3738\0\u3784\0\u37d0\0\u381c\0\u01c8"+
    "\0\u01c8\0\u01c8\0\u3868\0\u38b4\0\u3900\0\u394c\0\u3998\0\u39e4"+
    "\0\u3a30\0\u3a7c\0\u3ac8\0\u3b14\0\u3b60\0\u3bac\0\u3bf8\0\u3c44"+
    "\0\u3c90\0\u3cdc\0\u3d28\0\u3d74\0\u3dc0\0\u3e0c\0\u3e58\0\u3ea4"+
    "\0\u3ef0\0\u3f3c\0\u3f88\0\u3fd4\0\u01c8\0\u4020\0\u406c\0\u40b8"+
    "\0\u4104\0\u4150\0\u419c\0\u41e8\0\u01c8\0\u4234\0\u4280\0\u42cc"+
    "\0\u4318\0\u01c8\0\u4364\0\u43b0\0\u43fc\0\u4448\0\u4494\0\u44e0"+
    "\0\u452c\0\u4578\0\u45c4\0\u0d10\0\u0130\0\u01c8\0\u4610\0\u465c"+
    "\0\u46a8\0\u46f4\0\u4740\0\u478c\0\u47d8\0\u01c8\0\u4824\0\u4870"+
    "\0\u48bc\0\u01c8\0\u4908\0\u4954\0\u49a0\0\u49ec\0\u4a38\0\u4a84"+
    "\0\u4ad0\0\u4b1c\0\u4b68\0\u4bb4\0\u4c00\0\u4c4c\0\u4c98\0\u4ce4"+
    "\0\u4d30\0\u4d7c\0\u4dc8\0\u4e14\0\u4e60\0\u4eac\0\u4ef8\0\u01c8"+
    "\0\u4f44\0\u4f90\0\u4fdc\0\u5028\0\u5074\0\u50c0\0\u510c\0\u5158"+
    "\0\u01c8\0\u51a4\0\u51f0\0\u0130\0\u01c8\0\u0130\0\u0d10\0\u0d10"+
    "\0\u523c\0\u5288\0\u01c8\0\u01c8";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[332];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\5\1\6\2\7\1\10\1\5\1\10\1\11\1\12"+
    "\2\5\1\13\1\14\1\15\1\10\1\16\1\17\1\20"+
    "\1\5\1\21\1\10\1\22\1\10\1\23\1\24\1\10"+
    "\1\25\1\26\1\10\1\27\2\10\1\30\1\10\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\1\42\1\43\1\44\1\45\4\10\1\46\1\47\1\7"+
    "\4\10\1\50\1\51\2\10\1\52\1\53\1\54\1\55"+
    "\1\56\1\57\1\60\1\61\1\62\1\5\4\10\1\63"+
    "\2\5\103\63\1\64\1\65\4\63\1\66\2\5\102\66"+
    "\1\67\1\66\1\70\4\66\1\5\1\6\2\7\1\71"+
    "\1\5\1\71\4\5\1\72\2\5\1\71\2\5\1\71"+
    "\1\5\12\71\1\73\2\71\1\74\6\71\1\75\1\76"+
    "\4\71\1\77\1\100\6\71\1\7\10\71\4\5\1\56"+
    "\1\57\1\60\3\5\4\71\116\0\1\7\116\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\42\10"+
    "\1\0\10\10\12\0\4\10\14\0\2\103\111\0\1\104"+
    "\107\0\1\103\4\0\2\105\1\106\5\0\1\106\76\0"+
    "\1\103\4\0\2\15\1\106\5\0\1\106\74\0\2\10"+
    "\1\101\1\102\3\0\2\10\1\107\1\0\2\10\1\0"+
    "\7\10\1\110\32\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\2\10\1\107\1\0\2\10"+
    "\1\0\1\10\1\111\2\10\1\112\2\10\1\113\32\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\12\10\1\114\2\10"+
    "\1\115\14\10\1\116\1\117\6\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\32\10\1\120\1\121\6\10\1\0\1\122"+
    "\1\123\6\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\15\10\1\115\15\10"+
    "\1\117\6\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\33\10"+
    "\1\124\6\10\1\0\1\10\1\123\6\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\11\10\1\125\2\10\1\126\25\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\10\10\1\127\1\130\2\10\1\131"+
    "\2\10\1\132\22\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\3\10\1\0\2\10\1\0"+
    "\14\10\1\133\2\10\1\132\22\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\14\10\1\126\25\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\21\10\1\134\1\135\17\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\24\10\1\136\1\137\14\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\3\10\1\0\2\10\1\0\25\10\1\137\14\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\3\10\1\0\2\10\1\0\22\10\1\135\17\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\3\10\1\0\1\10\1\140\1\0\1\141\1\10\1\142"+
    "\2\10\1\143\20\10\1\144\1\145\12\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\1\10\1\140\1\0\5\10\1\143\21\10\1\145"+
    "\12\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\12\10\1\146"+
    "\2\10\1\147\16\10\1\150\1\151\4\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\15\10\1\147\17\10\1\151\4\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\2\10\1\152\1\0\2\10\1\0\1\10\1\153"+
    "\22\10\1\154\1\155\4\10\1\156\1\157\6\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\2\10\1\152\1\0\2\10\1\0\25\10\1\155\5\10"+
    "\1\157\6\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\1\10\1\160\1\0"+
    "\1\160\1\10\1\161\23\10\2\162\12\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\1\10\1\160\1\0\5\10\1\163\21\10\1\162"+
    "\12\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\2\10\1\164\1\0\2\10\1\0\1\10"+
    "\1\165\40\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\2\10\1\164\1\0\2\10\1\0"+
    "\42\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\11\10\1\166"+
    "\2\10\1\167\25\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\3\10\1\0\2\10\1\0"+
    "\14\10\1\170\25\10\1\0\10\10\12\0\4\10\76\0"+
    "\1\171\113\0\1\172\2\0\1\171\110\0\1\173\15\0"+
    "\1\63\2\0\103\63\2\0\4\63\32\0\1\174\4\0"+
    "\1\175\12\0\1\176\33\0\1\177\1\200\4\0\1\66"+
    "\2\0\102\66\1\0\1\66\1\0\4\66\32\0\1\174"+
    "\4\0\1\175\12\0\1\176\32\0\1\201\1\0\1\200"+
    "\11\0\4\71\3\0\3\71\2\0\44\71\1\0\11\71"+
    "\1\0\2\71\6\0\4\71\10\0\1\202\110\0\4\71"+
    "\3\0\3\71\2\0\44\71\1\0\2\71\1\203\1\204"+
    "\5\71\1\0\2\71\6\0\4\71\5\0\4\71\3\0"+
    "\3\71\2\0\44\71\1\0\3\71\1\204\5\71\1\0"+
    "\2\71\6\0\4\71\5\0\4\71\3\0\3\71\2\0"+
    "\30\71\1\205\1\206\12\71\1\0\11\71\1\0\2\71"+
    "\6\0\4\71\5\0\4\71\3\0\3\71\2\0\31\71"+
    "\1\206\12\71\1\0\11\71\1\0\2\71\6\0\4\71"+
    "\5\0\4\71\3\0\3\71\2\0\30\71\1\207\1\210"+
    "\12\71\1\0\11\71\1\0\2\71\6\0\4\71\5\0"+
    "\4\71\3\0\3\71\2\0\31\71\1\210\12\71\1\0"+
    "\11\71\1\0\2\71\6\0\4\71\4\0\1\211\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\42\10"+
    "\1\0\10\10\12\0\4\10\4\0\1\212\1\0\1\212"+
    "\4\0\1\213\1\214\1\215\1\212\2\0\1\212\1\0"+
    "\42\212\1\0\10\212\12\0\4\212\14\0\2\103\1\106"+
    "\5\0\1\106\106\0\1\216\110\0\2\217\1\0\2\220"+
    "\100\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\5\10\1\221\34\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\25\10\1\222\14\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\2\10\1\223\37\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\24\10\1\224\15\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\25\10\1\225\14\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\3\10\1\226\36\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\6\10\1\227\33\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\13\10\1\230\22\10\1\231\3\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\16\10\1\232\20\10\1\233\2\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\13\10\1\234\26\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\16\10\1\235\23\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\42\10\1\0\2\10"+
    "\1\236\5\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\42\10\1\0\3\10"+
    "\1\237\4\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\16\10\1\240\23\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\12\10\1\241\27\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\15\10\1\242\24\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\10\10\1\243\31\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\30\10\1\244\11\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\31\10\1\245\10\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\17\10\1\246\22\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\31\10\1\247\10\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\1\10\1\250\40\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\2\10\1\251\1\0\2\10\1\0\42\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\3\10\1\0\2\10\1\0\42\10\1\0\6\10\1\252"+
    "\1\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\3\10\1\0\2\10\1\0\42\10\1\0\7\10\1\253"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\6\10\1\254\33\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\3\10\1\254\36\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\2\10\1\255\37\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\5\10\1\255\34\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\30\10\1\256\11\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\31\10\1\256\10\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\4\10\1\257\35\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\7\10\1\257\32\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\2\10\1\260\37\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\5\10\1\261\34\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\1\10\1\262\1\0\42\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\1\263\41\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\4\10\1\264\35\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\7\10\1\265\32\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\1\266\41\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\3\10\1\0\1\10\1\267"+
    "\1\0\42\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\32\10"+
    "\1\270\1\271\6\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\3\10\1\0\2\10\1\0"+
    "\33\10\1\271\6\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\3\10\1\0\2\10\1\0"+
    "\7\10\1\272\32\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\3\10\1\0\2\10\1\0"+
    "\4\10\1\273\35\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\3\10\1\0\2\10\1\0"+
    "\12\10\1\274\27\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\3\10\1\0\2\10\1\0"+
    "\15\10\1\275\24\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\3\10\1\0\2\10\1\0"+
    "\15\10\1\276\24\10\1\0\10\10\12\0\4\10\5\0"+
    "\4\71\3\0\3\71\2\0\3\71\1\277\40\71\1\0"+
    "\11\71\1\0\2\71\6\0\4\71\5\0\4\71\3\0"+
    "\2\71\1\300\2\0\44\71\1\0\11\71\1\0\2\71"+
    "\6\0\4\71\5\0\4\71\3\0\3\71\2\0\26\71"+
    "\1\301\15\71\1\0\11\71\1\0\2\71\6\0\4\71"+
    "\5\0\4\71\3\0\3\71\2\0\27\71\1\302\14\71"+
    "\1\0\11\71\1\0\2\71\6\0\4\71\5\0\4\71"+
    "\3\0\3\71\2\0\32\71\1\303\11\71\1\0\11\71"+
    "\1\0\2\71\6\0\4\71\5\0\4\71\3\0\3\71"+
    "\2\0\33\71\1\304\10\71\1\0\11\71\1\0\2\71"+
    "\6\0\4\71\5\0\2\211\1\305\4\0\3\211\1\0"+
    "\2\211\1\0\42\211\1\0\10\211\12\0\4\211\5\0"+
    "\3\212\1\102\1\306\2\0\3\212\1\0\2\212\1\0"+
    "\42\212\1\0\10\212\12\0\4\212\10\0\1\102\3\0"+
    "\1\214\1\215\106\0\1\102\113\0\1\102\3\0\2\215"+
    "\114\0\1\307\5\0\1\307\103\0\2\217\103\0\2\10"+
    "\1\101\1\102\3\0\2\10\1\310\1\0\2\10\1\0"+
    "\42\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\14\10\1\311"+
    "\25\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\1\10\1\312"+
    "\40\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\11\10\1\313"+
    "\30\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\14\10\1\314"+
    "\25\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\24\10\1\315"+
    "\15\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\25\10\1\316"+
    "\14\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\32\10\1\317"+
    "\7\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\1\10\1\320"+
    "\40\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\33\10\1\321"+
    "\6\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\2\10\1\320\1\0\2\10\1\0\42\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\1\10\1\322\40\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\2\10\1\323\1\0\2\10\1\0\42\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\3\10\1\0\2\10\1\0\1\10\1\324\40\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\2\10\1\324\1\0\2\10\1\0\42\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\2\10"+
    "\1\325\1\0\2\10\1\0\42\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\13\10\1\326\26\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\16\10\1\326\23\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\1\327\41\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\1\10\1\330\40\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\2\10\1\331\1\0"+
    "\2\10\1\0\42\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\3\10\1\0\1\10\1\332"+
    "\1\0\42\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\2\10\1\333\1\0\2\10\1\0"+
    "\42\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\11\10\1\334"+
    "\30\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\14\10\1\335"+
    "\25\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\32\10\1\336"+
    "\7\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\33\10\1\337"+
    "\6\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\2\10\1\340"+
    "\37\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\5\10\1\340"+
    "\34\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\6\10\1\341"+
    "\33\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\3\10\1\341"+
    "\36\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\1\10\1\342"+
    "\40\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\2\10\1\342\1\0\2\10\1\0\42\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\4\10\1\343\35\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\7\10\1\344\32\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\36\10\1\345\3\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\37\10\1\346\2\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\23\10\1\347\16\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\20\10\1\350\21\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\34\10\1\351\5\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\35\10\1\352\4\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\35\10\1\353\4\10"+
    "\1\0\10\10\12\0\4\10\5\0\4\71\3\0\3\71"+
    "\2\0\13\71\1\354\30\71\1\0\11\71\1\0\2\71"+
    "\6\0\4\71\5\0\4\71\3\0\3\71\2\0\16\71"+
    "\1\355\25\71\1\0\11\71\1\0\2\71\6\0\4\71"+
    "\5\0\4\71\3\0\3\71\2\0\4\71\1\356\37\71"+
    "\1\0\11\71\1\0\2\71\6\0\4\71\5\0\4\71"+
    "\3\0\3\71\2\0\7\71\1\357\34\71\1\0\11\71"+
    "\1\0\2\71\6\0\4\71\5\0\4\71\3\0\3\71"+
    "\2\0\3\71\1\360\40\71\1\0\11\71\1\0\2\71"+
    "\6\0\4\71\5\0\4\71\3\0\2\71\1\361\2\0"+
    "\44\71\1\0\11\71\1\0\2\71\6\0\4\71\4\0"+
    "\3\211\1\305\4\0\3\211\1\0\2\211\1\0\42\211"+
    "\1\0\10\211\12\0\4\211\13\0\1\362\1\363\1\364"+
    "\117\0\1\365\1\0\1\365\75\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\6\10\1\366\33\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\7\10\1\367\32\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\3\10\1\370\36\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\4\10\1\371\35\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\7\10\1\372\32\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\4\10\1\373\35\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\7\10\1\374\32\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\4\10\1\375\35\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\7\10\1\375\32\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\1\376\41\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\3\10\1\0\1\10\1\377\1\0\1\377\41\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\3\10\1\0\1\10\1\377\1\0\42\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\1\10\1\u0100\40\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\11\10\1\u0101\30\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\14\10\1\u0102\25\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\2\10"+
    "\1\u0103\1\0\2\10\1\0\42\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\14\10\1\u0104\25\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\1\10\1\u0105\40\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\2\10\1\u0105"+
    "\1\0\2\10\1\0\42\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\26\10\1\u0106\13\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\27\10\1\u0107\12\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\32\10\1\u0108\7\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\33\10\1\u0109\6\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\1\10\1\u010a\40\10\1\0\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\2\10\1\u010a\1\0"+
    "\2\10\1\0\42\10\1\0\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\2\10\1\u010b\1\0\2\10"+
    "\1\0\42\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\1\10"+
    "\1\u010c\40\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\42\10"+
    "\1\0\2\10\1\u010d\5\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\42\10"+
    "\1\0\3\10\1\u010e\4\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\42\10"+
    "\1\0\3\10\1\u010f\4\10\12\0\4\10\5\0\4\71"+
    "\3\0\3\71\2\0\26\71\1\u0110\15\71\1\0\11\71"+
    "\1\0\2\71\6\0\4\71\5\0\4\71\3\0\3\71"+
    "\2\0\27\71\1\u0111\14\71\1\0\11\71\1\0\2\71"+
    "\6\0\4\71\5\0\4\71\3\0\3\71\2\0\44\71"+
    "\1\0\1\u0112\10\71\1\0\2\71\6\0\4\71\5\0"+
    "\4\71\3\0\3\71\2\0\44\71\1\0\1\71\1\u0113"+
    "\7\71\1\0\2\71\6\0\4\71\5\0\4\71\3\0"+
    "\3\71\2\0\44\71\1\0\11\71\1\0\2\71\6\0"+
    "\1\u0114\3\71\5\0\4\71\3\0\3\71\2\0\44\71"+
    "\1\0\11\71\1\0\2\71\6\0\1\71\1\u0114\2\71"+
    "\12\0\1\214\1\0\1\363\1\364\110\0\1\214\113\0"+
    "\1\214\1\0\2\364\103\0\1\u0115\113\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\7\10\1\u0116"+
    "\32\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\1\10\1\u0117\1\0\42\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\4\10\1\u0116\35\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\1\u0118\41\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\3\10\1\0\1\10\1\u0119\1\0\42\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\32\10\1\u011a\7\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\33\10\1\u011b\6\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\4\10\1\u011c\35\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\7\10\1\u011d\32\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\4\10\1\u011e\35\10\1\0\10\10"+
    "\12\0\4\10\5\0\2\10\1\101\1\102\3\0\3\10"+
    "\1\0\2\10\1\0\42\10\1\u011f\10\10\12\0\4\10"+
    "\5\0\2\10\1\101\1\102\3\0\3\10\1\0\2\10"+
    "\1\0\42\10\1\u0120\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\7\10"+
    "\1\u011e\32\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\42\10"+
    "\1\u0121\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\42\10\1\0\4\10"+
    "\1\u0122\3\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\42\10\1\0\5\10"+
    "\1\u0122\2\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\26\10\1\u0123\13\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\27\10\1\u0124\12\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\2\10\1\u0125\1\0\2\10\1\0\42\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\3\10\1\0\2\10\1\0\1\10\1\u0126\40\10\1\0"+
    "\10\10\12\0\4\10\5\0\2\10\1\101\1\102\3\0"+
    "\3\10\1\0\2\10\1\0\42\10\1\u0127\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\42\10\1\u0128\10\10\12\0\4\10\5\0"+
    "\2\10\1\101\1\102\3\0\3\10\1\0\2\10\1\0"+
    "\42\10\1\u0129\10\10\12\0\4\10\5\0\4\71\3\0"+
    "\3\71\2\0\6\71\1\u012a\35\71\1\0\11\71\1\0"+
    "\2\71\6\0\4\71\5\0\4\71\3\0\3\71\2\0"+
    "\11\71\1\u012b\32\71\1\0\11\71\1\0\2\71\6\0"+
    "\4\71\5\0\4\71\3\0\3\71\2\0\44\71\1\0"+
    "\11\71\1\0\2\71\6\0\2\71\1\u012c\1\71\5\0"+
    "\4\71\3\0\3\71\2\0\44\71\1\0\11\71\1\0"+
    "\2\71\6\0\3\71\1\u012d\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\23\10\1\u012e\16\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\20\10\1\u012f\21\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\20\10\1\u012e\2\10"+
    "\1\u012e\16\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\12\10"+
    "\1\u0130\27\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\15\10"+
    "\1\u0131\24\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\24\10"+
    "\1\u0132\15\10\1\0\10\10\12\0\4\10\5\0\2\10"+
    "\1\101\1\102\3\0\3\10\1\0\2\10\1\0\25\10"+
    "\1\u0133\14\10\1\0\10\10\12\0\4\10\63\0\1\u0134"+
    "\113\0\1\u0135\114\0\1\u0135\34\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\3\10\1\u0136\36\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\6\10\1\u0137\33\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\27\10\1\u0138\12\10"+
    "\1\0\10\10\12\0\4\10\5\0\2\10\1\101\1\102"+
    "\3\0\3\10\1\0\2\10\1\0\26\10\1\u0138\13\10"+
    "\1\0\10\10\12\0\4\10\63\0\1\u0139\113\0\1\u013a"+
    "\114\0\1\u013a\34\0\4\71\3\0\3\71\2\0\14\71"+
    "\1\u013b\27\71\1\0\11\71\1\0\2\71\6\0\4\71"+
    "\5\0\4\71\3\0\3\71\2\0\17\71\1\u013c\24\71"+
    "\1\0\11\71\1\0\2\71\6\0\4\71\5\0\4\71"+
    "\3\0\3\71\2\0\3\71\1\u013d\40\71\1\0\11\71"+
    "\1\0\2\71\6\0\4\71\5\0\4\71\3\0\2\71"+
    "\1\u013e\2\0\44\71\1\0\11\71\1\0\2\71\6\0"+
    "\4\71\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\33\10\1\u013f\6\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\32\10\1\u0140\7\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\26\10\1\u0141\13\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\27\10\1\u0141\12\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\13\10\1\u0142\26\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\16\10\1\u0143\23\10\1\0\10\10\12\0"+
    "\4\10\66\0\1\u0144\114\0\1\u0144\31\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\4\10\1\u0145"+
    "\35\10\1\0\10\10\12\0\4\10\5\0\2\10\1\101"+
    "\1\102\3\0\3\10\1\0\2\10\1\0\7\10\1\u0145"+
    "\32\10\1\0\10\10\12\0\4\10\66\0\1\u0146\114\0"+
    "\1\u0146\31\0\4\71\3\0\3\71\2\0\13\71\1\u0147"+
    "\30\71\1\0\11\71\1\0\2\71\6\0\4\71\5\0"+
    "\4\71\3\0\3\71\2\0\16\71\1\u0147\25\71\1\0"+
    "\11\71\1\0\2\71\6\0\4\71\5\0\4\71\3\0"+
    "\3\71\2\0\13\71\1\u0148\30\71\1\0\11\71\1\0"+
    "\2\71\6\0\4\71\5\0\4\71\3\0\3\71\2\0"+
    "\16\71\1\u0148\25\71\1\0\11\71\1\0\2\71\6\0"+
    "\4\71\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\7\10\1\u0149\32\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\4\10\1\u014a\35\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\42\10\1\0\2\10\1\u014b\5\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\42\10\1\0\3\10\1\u014b\4\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\22\10\1\u014c\17\10\1\0\10\10\12\0"+
    "\4\10\5\0\2\10\1\101\1\102\3\0\3\10\1\0"+
    "\2\10\1\0\21\10\1\u014c\20\10\1\0\10\10\12\0"+
    "\4\10";

  private static int [] zzUnpackTrans() {
    int [] result = new int[21204];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\4\0\1\11\1\1\1\11\3\1\1\11\2\1\2\11"+
    "\32\1\1\11\3\1\5\11\1\1\1\11\2\1\1\11"+
    "\12\1\1\0\1\1\1\0\1\1\1\0\62\1\12\11"+
    "\13\1\1\0\1\1\1\0\65\1\2\0\52\1\4\0"+
    "\37\1\1\11\11\1\3\0\5\1\3\0\12\1\2\0"+
    "\3\1\2\0\11\1\1\11\1\1\1\11\6\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[332];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  StringBuffer string = new StringBuffer();

  private Symbol symbol(int type) {
    return new Symbol(type, -1, yychar, yytext());
  }

  private Symbol symbol(int type, Object value) {
    return new Symbol(type, -1, yychar, value);
  }

  private void scanError() throws QueryParseException {
    StringBuffer buf = new StringBuffer("Lexical Error: Illegal character <")
        .append(yytext()).append("> at offset ").append(yychar);
      throw new QueryParseException(buf.toString());
  }



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Scanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Scanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1726) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 2: 
          { /* ignore */
          }
        case 65: break;
        case 55: 
          { return symbol(sym.HAVING);
          }
        case 66: break;
        case 25: 
          { return symbol(sym.IS);
          }
        case 67: break;
        case 49: 
          { return symbol(sym.WHERE);
          }
        case 68: break;
        case 46: 
          { return symbol(sym.DESC);
          }
        case 69: break;
        case 11: 
          { return symbol(sym.GT);
          }
        case 70: break;
        case 59: 
          { return symbol(sym.DISTINCT);
          }
        case 71: break;
        case 30: 
          { string.append('\t');
          }
        case 72: break;
        case 7: 
          { return symbol(sym.SUM);
          }
        case 73: break;
        case 10: 
          { return symbol(sym.LT);
          }
        case 74: break;
        case 15: 
          { string.setLength(0); yybegin(STRING);
          }
        case 75: break;
        case 63: 
          { return symbol(sym.TIMESTAMP);
          }
        case 76: break;
        case 50: 
          { return symbol(sym.ILIKE);
          }
        case 77: break;
        case 29: 
          { return symbol(sym.GTEQ);
          }
        case 78: break;
        case 62: 
          { return symbol(sym.ANALYZER);
          }
        case 79: break;
        case 22: 
          { return symbol(sym.DOUBLE, yytext());
          }
        case 80: break;
        case 41: 
          { return symbol(sym.NOT);
          }
        case 81: break;
        case 40: 
          { return symbol(sym.AND);
          }
        case 82: break;
        case 4: 
          { return symbol(sym.DIV);
          }
        case 83: break;
        case 19: 
          { string.append('\\');
          }
        case 84: break;
        case 31: 
          { string.append('\r');
          }
        case 85: break;
        case 56: 
          { return symbol(sym.BETWEEN);
          }
        case 86: break;
        case 54: 
          { return symbol(sym.OFFSET);
          }
        case 87: break;
        case 47: 
          { return symbol(sym.DATE);
          }
        case 88: break;
        case 38: 
          { return symbol(sym.ASC);
          }
        case 89: break;
        case 8: 
          { return symbol(sym.SUB);
          }
        case 90: break;
        case 43: 
          { return symbol(sym.TYPE);
          }
        case 91: break;
        case 21: 
          { return symbol(sym.ES_IDENTIFIER, yytext());
          }
        case 92: break;
        case 3: 
          { return symbol(sym.IDENTIFIER, yytext());
          }
        case 93: break;
        case 34: 
          { string.append('\"');
          }
        case 94: break;
        case 39: 
          { return symbol(sym.ALL);
          }
        case 95: break;
        case 1: 
          { scanError();
          }
        case 96: break;
        case 58: 
          { return symbol(sym.ORDERBY);
          }
        case 97: break;
        case 20: 
          { yybegin(YYINITIAL);
                          return symbol(sym.STRING, string.toString());
          }
        case 98: break;
        case 33: 
          { string.append('\'');
          }
        case 99: break;
        case 42: 
          { return symbol(sym.LIKE);
          }
        case 100: break;
        case 23: 
          { return symbol(sym.OR);
          }
        case 101: break;
        case 26: 
          { return symbol(sym.IN);
          }
        case 102: break;
        case 9: 
          { return symbol(sym.EQ);
          }
        case 103: break;
        case 61: 
          { return symbol(sym.OPERATOR);
          }
        case 104: break;
        case 18: 
          { yybegin(YYINITIAL);
                          return symbol(sym.STRING,string.toString());
          }
        case 105: break;
        case 36: 
          { return symbol(sym.FROM_IDENTIFIER, yytext());
          }
        case 106: break;
        case 35: 
          { yybegin(YYINITIAL);
                          return symbol(sym.RHINT);
          }
        case 107: break;
        case 37: 
          { return symbol(sym.PATH_IDENTIFIER, yytext());
          }
        case 108: break;
        case 32: 
          { string.append('\n');
          }
        case 109: break;
        case 57: 
          { return symbol(sym.LOCATION);
          }
        case 110: break;
        case 28: 
          { return symbol(sym.LTEQ);
          }
        case 111: break;
        case 24: 
          { return symbol(sym.AS);
          }
        case 112: break;
        case 12: 
          { return symbol(sym.LPARA);
          }
        case 113: break;
        case 44: 
          { return symbol(sym.FROM);
          }
        case 114: break;
        case 53: 
          { return symbol(sym.SELECT);
          }
        case 115: break;
        case 13: 
          { return symbol(sym.RPARA);
          }
        case 116: break;
        case 64: 
          { return symbol(sym.STARTSWITH);
          }
        case 117: break;
        case 27: 
          { return symbol(sym.NOTEQ);
          }
        case 118: break;
        case 16: 
          { string.setLength(0); yybegin(SQ_STRING);
          }
        case 119: break;
        case 14: 
          { return symbol(sym.COMMA);
          }
        case 120: break;
        case 5: 
          { return symbol(sym.MUL);
          }
        case 121: break;
        case 60: 
          { return symbol(sym.GROUPBY);
          }
        case 122: break;
        case 52: 
          { string.setLength(0); yybegin(ES_HINT); return symbol(sym.LHINT_ES);
          }
        case 123: break;
        case 51: 
          { return symbol(sym.INDEX);
          }
        case 124: break;
        case 17: 
          { string.append( yytext() );
          }
        case 125: break;
        case 6: 
          { return symbol(sym.INTEGER, yytext());
          }
        case 126: break;
        case 45: 
          { return symbol(sym.NULL);
          }
        case 127: break;
        case 48: 
          { return symbol(sym.LIMIT);
          }
        case 128: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              { return new java_cup.runtime.Symbol(sym.EOF); }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
