/*
 * Copyright (c) 2003-2006 OFFIS, Henri Tremblay. 
 * This program is made available under the terms of the MIT License.
 */
package org.easymock.classextension.internal;

import static org.easymock.classextension.internal.ClassExtensionHelper.getInterceptor;

import java.lang.reflect.Method;

import org.easymock.classextension.IMocksControl;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.MocksControl;

public class MocksClassControl extends MocksControl implements
        IMocksControl {

    public MocksClassControl(MockType type) {
        super(type);
    }

    public <T> T createMock(Class<T> toMock, Method[] mockedMethods) {
        T mock = createMock(toMock);

        // Set the mocked methods on the interceptor
        getInterceptor(mock).setMockedMethods(mockedMethods);

        return mock;
    }

    protected <T> IProxyFactory<T> createProxyFactory(Class<T> toMock) {
        if (toMock.isInterface()) {
            return super.createProxyFactory(toMock);
        }
        return new ClassProxyFactory<T>();
    }
}
