/*
 * (C) Copyright 2013 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     dmetzler
 */
package org.nuxeo.ecm.restapi.server.jaxrs.adapters;

import javax.ws.rs.GET;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

/**
 * @since 5.7.3
 */
@WebAdapter(name = "acl", type = "aclAdapter", targetType = "document")
public class ACLAdapter extends DefaultAdapter {

    @GET
    public ACP doGetACP() {
        DefaultObject target = (DefaultObject) getTarget();
        DocumentModel doc = target.getAdapter(DocumentModel.class);

        if (doc == null) {
            throw new IllegalArgumentException("Targeted resource should be adaptable to a document");
        }

        return doc.getACP();
    }
}
