/*
 * (C) Copyright 2006-2008 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Stephane Lacoin (Nuxeo EP Software Engineer)
 */

package org.nuxeo.ecm.platform.audit.service;

import org.nuxeo.ecm.platform.audit.api.LogEntry;

/**
 * Minimal interface extracted to be able to share some code inside the {@link AbstractAuditBackend}
 * 
 * @author tiry
 */
public interface BaseLogEntryProvider {

    public abstract void addLogEntry(LogEntry entry);

    public abstract int removeEntries(String eventId, String pathPattern);

}
