/*
 * (C) Copyright 2006-2014 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.nuxeo.ecm.core.redis.retry;

import java.util.concurrent.TimeUnit;

import org.apache.commons.logging.LogFactory;

public class SimpleDelay implements Retry.Policy {

    protected final int base;

    protected final long delay;

    protected int elapsed;

    public SimpleDelay(int base, int delay) {
        this.base = base;
        this.delay = TimeUnit.MILLISECONDS.convert(delay, TimeUnit.SECONDS);
    }

    @Override
    public boolean allow() {
        return elapsed < delay;
    }

    @Override
    public void pause() {
        long computed = computeDelay();
        LogFactory.getLog(SimpleDelay.class).warn("pausing for " + computed + " ms");
        try {
            Thread.sleep(computed);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        elapsed += computed;
    }

    protected long computeDelay() {
        return base;
    }

}
