/*
 * (C) Copyright 2006-2008 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     bstefanescu
 *
 * $Id$
 */

package org.nuxeo.ecm.webengine.session;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 */
public abstract class AbstractComponent implements Component {

    private static final long serialVersionUID = 3472450841328363350L;

    protected String name;

    private boolean isLive;

    public String getName() {
        return name;
    }

    public boolean isLive() {
        return isLive;
    }

    public void initialize(UserSession session, String name) throws SessionException {
        if (isLive) {
            throw new InvalidStateException(this, "initialize");
        }
        this.name = name;
        doInitialize(session, name);
        isLive = true;
    }

    public void destroy(UserSession session) throws SessionException {
        if (!isLive) {
            throw new InvalidStateException(this, "destroy");
        }
        doDestroy(session);
        name = null;
        isLive = false;
    }

    public void doInitialize(UserSession session, String name) throws SessionException {
        // do nothing by default
    }

    public void doDestroy(UserSession session) throws SessionException {
        // do nothing by default
    }

}
