/*
 * (C) Copyright 2006-2008 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 */

package org.nuxeo.ecm.platform.ui.web.auth.interfaces;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;

public interface NuxeoAuthenticationPlugin {

    /**
     * Handles the Login Prompt.
     *
     * @param httpRequest the request
     * @param httpResponse the response
     * @return true if AuthFilter must stop execution (ie: login prompt generated a redirect), false otherwise
     */
    Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL);

    /**
     * Retrieves user identification information from the request.
     *
     * @param httpRequest the request
     * @param httpResponse the response
     */
    UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse);

    /**
     * Defines if the authentication plugin needs to do a login prompt.
     *
     * @return true if LoginPrompt is used
     */
    Boolean needLoginPrompt(HttpServletRequest httpRequest);

    /**
     * Initializes the Plugin from parameters set in the XML descriptor.
     */
    void initPlugin(Map<String, String> parameters);

    /**
     * Returns the list of prefix for unauthenticated URLs, typically the URLs associated to login prompt.
     */
    List<String> getUnAuthenticatedURLPrefix();

}
