/*
 * (C) Copyright 2006-2009 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Nuxeo
 */

package org.nuxeo.ecm.platform.web.common.exceptionhandling;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface NuxeoExceptionHandler {

    String EXCEPTION_HANDLER_MARKER = "NuxeoExceptionHandlerMarker";

    void handleException(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException,
            ServletException;

    void setParameters(NuxeoExceptionHandlerParameters parameters);

    /**
     * Handles the Security Error when the user is anonymous.
     *
     * @return {@code true} if the Security Error is handled so that the calling method won't fallback on the default
     *         handler, {@code false} otherwise.
     * @since 8.3
     */
    boolean handleAnonymousException(HttpServletRequest request, HttpServletResponse response)
            throws IOException, ServletException;

    /**
     * Gets the URL to redirect to when a login is needed for an Anonymous user.
     *
     * @since 8.3
     */
    String getLoginURL(HttpServletRequest request);

}
