/*
 * (C) Copyright 2010 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */
package org.nuxeo.ecm.platform.video.convert;

/**
 * Constants used for converters.
 */
public class Constants {

    public static final String STORYBOARD_CONVERTER = "videoStoryboard";

    public static final String SCREENSHOT_CONVERTER = "videoScreenshot";

    public static final String TO_MP4_CONVERTER = "convertToMP4";

    public static final String TO_WEBM_CONVERTER = "convertToWebM";

    public static final String TO_OGG_CONVERTER = "convertToOgg";

    public static final String POSITION_PARAMETER = "position";

    public static final String INPUT_FILE_PATH_PARAMETER = "inFilePath";

    public static final String OUTPUT_FILE_PATH_PARAMETER = "outFilePath";

    public static final String OUTPUT_FILE_NAME_PARAMETER = "outFileName";

    // Constant utility class.
    private Constants() {
    }

}
