/*
 * JBoss, Home of Professional Open Source
 * Copyright (c) 2010, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.core.context;

import org.jboss.aop.Advisor;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.annotation.TransactionTimeout;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisor;

import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import java.lang.reflect.Method;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 */
public class TxUtil extends org.jboss.ejb3.tx.TxUtil
{
   protected static int getTransactionTimeout(MethodInvocation invocation)
   {
      return getTransactionTimeout(invocation.getAdvisor(), invocation.getActualMethod());
   }

   protected static int getTransactionTimeout(Advisor advisor, Method method)
   {
      TransactionTimeout annotation = (TransactionTimeout)advisor.resolveAnnotation(method, TransactionTimeout.class);

      if (annotation == null)
         annotation = (TransactionTimeout)advisor.resolveAnnotation(TransactionTimeout.class);

      if (annotation != null)
      {
         return annotation.value();
      }

      return -1;
   }

   protected static TransactionAttributeType getTxType(MethodInvocation invocation)
   {
      return getTxType(invocation.getAdvisor(), invocation.getActualMethod());
   }

//   protected static TransactionAttributeType getTxType(Advisor advisor, Method method)
//   {
//      return org.jboss.ejb3.tx.TxUtil.getTxType(advisor, method);
//   }
   
   protected static TransactionAttributeType getTxType(Advisor advisor, Method method)
   {
      TransactionAttribute tx = null;

      if(method != null)
         tx = (TransactionAttribute) advisor.resolveAnnotation(method, TransactionAttribute.class);

      if (tx == null)
      {
         if (advisor instanceof ExtendedAdvisor && method != null)
            tx = ((ExtendedAdvisor) advisor).resolveAnnotation(method.getDeclaringClass(), TransactionAttribute.class);
         else
            tx = (TransactionAttribute) advisor.resolveAnnotation(TransactionAttribute.class);
      }

      TransactionAttributeType value = TransactionAttributeType.REQUIRED;
      if (tx != null && tx.value() != null)
      {
         value = tx.value();
      }

      return value;
   }
}
