/*
 * (C) Copyright 2006-2007 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Jean-Marc Orliaguet, Chalmers
 *
 * $Id$
 */

package org.nuxeo.theme.elements;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.theme.nodes.NodeTypeFamily;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;

@XObject("element")
public final class ElementType implements Type {

    @XNode("@name")
    public String name;

    @XNode("class")
    public String className;

    @XNode("node-type")
    public String nodeTypeName;

    public ElementType() {
    }

    public ElementType(String name, String className, String nodeTypeName) {
        this.name = name;
        this.nodeTypeName = nodeTypeName;
        this.className = className;
    }

    public NodeTypeFamily getNodeTypeFamily() {
        if (nodeTypeName.equals("leaf")) {
            return NodeTypeFamily.LEAF;
        } else if (nodeTypeName.equals("inner")) {
            return NodeTypeFamily.INNER;
        }
        return null;
    }

    public String getTypeName() {
        return name;
    }

    public TypeFamily getTypeFamily() {
        return TypeFamily.ELEMENT;
    }

    public String getClassName() {
        return className;
    }

}
