/*
 * (C) Copyright 2011-2015 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Mathieu Guillaume
 */

package org.nuxeo.ecm.core.storage.sql;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;

public class BasicAWSCredentialsProvider implements AWSCredentialsProvider {

    protected BasicAWSCredentials basicAWSCredentials;

    public BasicAWSCredentialsProvider(String awsID, String awsSecret) {
        this.basicAWSCredentials = new BasicAWSCredentials(awsID, awsSecret);
    }

    public AWSCredentials getCredentials() {
        return basicAWSCredentials;
    }

    public void refresh() {
        // noop
    }

}
