/*
 * (C) Copyright 2015 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *      André Justo
 */

package org.nuxeo.ecm.media.publishing.wistia.rest;

import com.sun.jersey.api.client.ClientResponse;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

import java.io.IOException;

public class RestResponse {

    protected ClientResponse clientResponse;

    protected JsonNode responseAsJson;

    protected ObjectMapper objectMapper = new ObjectMapper();

    public RestResponse(ClientResponse clientResponse) {
        this.clientResponse = clientResponse;
    }

    public ClientResponse getClientResponse() {
        return this.clientResponse;
    }

    public int getStatus() {
        return this.clientResponse.getStatus();
    }

    public JsonNode asJson() {
        if (responseAsJson == null) {
            try {
                responseAsJson = objectMapper.readTree(clientResponse.getEntityInputStream());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return responseAsJson;
    }
}
