/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.NavigationSubPage;
import org.nuxeo.functionaltests.pages.admincenter.AdminCenterBasePage;
import org.nuxeo.functionaltests.pages.tabs.ContentTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.EditTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.ManageTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.SummaryTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.WorkspaceContentTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class DocumentBasePage
extends AbstractPage {
    @FindBy(xpath="//div[@class=\"tabsBar\"]/form/ul/li/a[text()=\"Content\"]")
    public WebElement contentTabLink;
    @FindBy(xpath="//div[@class=\"tabsBar\"]/form/ul/li/a[text()=\"Summary\"]")
    public WebElement summaryTabLink;
    @FindBy(xpath="//div[@class=\"tabsBar\"]/form/ul/li/a[text()=\"Edit\"]")
    public WebElement editTabLink;
    @FindBy(xpath="//div[@class=\"tabsBar\"]/form/ul/li/a[text()=\"Manage\"]")
    public WebElement manageTabLink;
    @FindBy(xpath="/html/body/table[2]/tbody/tr/td[2]/div[2]//div[@class=\"tabsBar\"]/form/ul/li[@class=\"selected\"]/a")
    public WebElement selectedTab;
    @FindBy(className="currentDocumentDescription")
    public WebElement currentDocumentDescription;
    @FindBy(xpath="/html/body/table[2]/tbody/tr/td[2]/div[2]//h1")
    public WebElement currentDocumentTitle;

    public DocumentBasePage(WebDriver driver) {
        super(driver);
    }

    public ContentTabSubPage getContentTab() {
        this.clickOnLinkIfNotSelected(this.contentTabLink);
        return this.asPage(ContentTabSubPage.class);
    }

    public EditTabSubPage getEditTab() {
        this.clickOnLinkIfNotSelected(this.editTabLink);
        return this.asPage(EditTabSubPage.class);
    }

    public SummaryTabSubPage getSummaryTab() {
        this.clickOnLinkIfNotSelected(this.summaryTabLink);
        return this.asPage(SummaryTabSubPage.class);
    }

    public ManageTabSubPage getManageTab() {
        this.clickOnLinkIfNotSelected(this.manageTabLink);
        return this.asPage(ManageTabSubPage.class);
    }

    public NavigationSubPage getNavigationSubPage() {
        return this.asPage(NavigationSubPage.class);
    }

    protected void clickOnLinkIfNotSelected(WebElement tabLink) {
        if (!this.selectedTab.equals(tabLink)) {
            tabLink.click();
        }
    }

    public WorkspaceContentTabSubPage getWorkspaceContentTab() {
        this.clickOnLinkIfNotSelected(this.contentTabLink);
        return this.asPage(WorkspaceContentTabSubPage.class);
    }

    public void checkUserConnected(String username) throws UserNotConnectedException {
        if (!this.getHeaderLinks().getText().contains(username)) {
            throw new UserNotConnectedException(username);
        }
    }

    public String getCurrentDocumentDescription() {
        return this.currentDocumentDescription.getText();
    }

    public String getCurrentDocumentTitle() {
        return this.currentDocumentTitle.getText();
    }

    public AdminCenterBasePage getAdminCenter() {
        DocumentBasePage.findElementWithTimeout(By.linkText((String)"Admin Center")).click();
        return this.asPage(AdminCenterBasePage.class);
    }

    public class UserNotConnectedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UserNotConnectedException(String username) {
            super("The user " + username + " is expected to be connected but isn't");
        }
    }
}

