/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.util.List;
import junit.framework.Assert;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class ContentTabSubPage
extends AbstractPage {
    @Required
    @FindBy(id="document_content")
    WebElement documentContentForm;
    @FindBy(linkText="New")
    WebElement newButton;
    @FindBy(xpath="//input[@value=\"Delete\"]")
    WebElement deleteButton;

    public ContentTabSubPage(WebDriver driver) {
        super(driver);
    }

    public DocumentBasePage goToDocument(String documentTitle) {
        this.documentContentForm.findElement(By.linkText((String)documentTitle)).click();
        return this.asPage(DocumentBasePage.class);
    }

    public <T> T getDocumentCreatePage(String docType, Class<T> pageClassToProxy) {
        this.newButton.click();
        WebElement link = null;
        for (WebElement element : this.driver.findElements(By.className((String)"documentType"))) {
            try {
                link = element.findElement(By.linkText((String)docType));
                break;
            }
            catch (NoSuchElementException e) {
            }
        }
        Assert.assertNotNull(link);
        link.click();
        return this.asPage(pageClassToProxy);
    }

    public DocumentBasePage removeDocument(String documentTitle) {
        List trelements = this.documentContentForm.findElements(By.tagName((String)"tr"));
        for (WebElement trItem : trelements) {
            try {
                trItem.findElement(By.linkText((String)documentTitle));
                WebElement checkBox = trItem.findElement(By.xpath((String)"//input[@type=\"checkbox\"][@name=\"document_content:nxl_document_listing_ajax:nxw_listing_ajax_selection_box_with_current_document\"]"));
                checkBox.click();
                break;
            }
            catch (NoSuchElementException e) {
            }
        }
        ContentTabSubPage.waitUntilEnabled(this.deleteButton);
        this.deleteButton.click();
        this.driver.switchTo().alert().accept();
        return this.asPage(DocumentBasePage.class);
    }
}

