/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter;

import org.nuxeo.functionaltests.pages.LoginPage;
import org.nuxeo.functionaltests.pages.admincenter.AdminCenterBasePage;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SystemHomePage
extends AdminCenterBasePage {
    public static final String HOST_SUBTAB = "Host";
    public static final String SETUP_SUBTAB = "Setup";

    public SystemHomePage(WebDriver driver) {
        super(driver);
    }

    public LoginPage restart() {
        WebElement restartButton;
        if (!HOST_SUBTAB.equals(this.getSelectedSubTab())) {
            this.selectSubTab(HOST_SUBTAB);
        }
        if ((restartButton = SystemHomePage.findElementWithTimeout(By.xpath((String)"//input[@type='submit' and @value='Restart server']"))) == null) {
            return null;
        }
        restartButton.click();
        Alert alert = this.driver.switchTo().alert();
        alert.accept();
        this.findElementWithTimeout(By.id((String)"username"), 180000);
        return this.asPage(LoginPage.class);
    }

    public boolean setConfig(String id, String value) {
        WebElement input;
        if (!SETUP_SUBTAB.equals(this.getSelectedSubTab())) {
            this.selectSubTab(SETUP_SUBTAB);
        }
        if ((input = SystemHomePage.findElementWithTimeout(By.xpath((String)("//td[@id='" + id + "']/input")))) != null) {
            input.sendKeys(new CharSequence[]{value});
            return true;
        }
        return false;
    }

    public String getConfig(String id) {
        WebElement input;
        if (!SETUP_SUBTAB.equals(this.getSelectedSubTab())) {
            this.selectSubTab(SETUP_SUBTAB);
        }
        if ((input = SystemHomePage.findElementWithTimeout(By.xpath((String)("//td[@id='" + id + "']/input")))) != null) {
            return input.getValue();
        }
        return null;
    }
}

