/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.admincenter.ConnectHomePage;
import org.nuxeo.functionaltests.pages.admincenter.SystemHomePage;
import org.nuxeo.functionaltests.pages.admincenter.UpdateCenterPage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UsersGroupsBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class AdminCenterBasePage
extends AbstractPage {
    @Required
    @FindBy(linkText="Users & groups")
    public WebElement userAndGroupsLink;
    public static final String DOCUMENT_MANAGEMENT = "Document Management";
    public static final String SYSTEM_INFORMATION = "System information";
    public static final String UPDATE_CENTER = "Update Center";
    public static final String NUXEO_CONNECT = "Nuxeo Connect";

    public AdminCenterBasePage(WebDriver driver) {
        super(driver);
    }

    public AdminCenterBasePage nav(String linkText) {
        return this.nav(AdminCenterBasePage.class, linkText);
    }

    public <T extends AbstractPage> T nav(Class<T> pageClass, String linkText) {
        WebElement link = AdminCenterBasePage.findElementWithTimeout(By.linkText((String)linkText));
        if (link == null) {
            return null;
        }
        link.click();
        return (T)((AbstractPage)this.asPage(pageClass));
    }

    public UsersGroupsBasePage getUsersGroupsHomePage() {
        this.userAndGroupsLink.click();
        return this.asPage(UsersGroupsBasePage.class);
    }

    public ConnectHomePage getConnectHomePage() {
        return this.nav(ConnectHomePage.class, NUXEO_CONNECT);
    }

    public UpdateCenterPage getUpdateCenterHomePage() {
        return this.nav(UpdateCenterPage.class, UPDATE_CENTER);
    }

    public SystemHomePage getSystemHomePage() {
        return this.nav(SystemHomePage.class, SYSTEM_INFORMATION);
    }

    public String getSelectedSubTab() {
        WebElement tab = AdminCenterBasePage.findElementWithTimeout(By.xpath((String)"//div[@class='tabsBar']//li[@class='selected']/a"));
        if (tab != null) {
            return tab.getText();
        }
        return null;
    }

    public AdminCenterBasePage selectSubTab(String text) {
        WebElement tab = AdminCenterBasePage.findElementWithTimeout(By.xpath((String)("//div[@class='tabsBar']//li/a[text()='" + text + "']")));
        if (tab != null) {
            tab.click();
            return this.asPage(AdminCenterBasePage.class);
        }
        return null;
    }

    public List<String> getAvailableSubTabs() {
        List elements = this.driver.findElements(By.xpath((String)"//div[@class='tabsBar']//li/a"));
        ArrayList<String> tabs = new ArrayList<String>();
        for (WebElement el : elements) {
            tabs.add(el.getText());
        }
        return tabs;
    }

    public DocumentBasePage exitAdminCenter() {
        AdminCenterBasePage.findElementWithTimeout(By.linkText((String)DOCUMENT_MANAGEMENT)).click();
        return this.asPage(DocumentBasePage.class);
    }
}

