/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.wizard;

import org.nuxeo.functionaltests.pages.AbstractPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public abstract class AbstractWizardPage
extends AbstractPage {
    protected static final String BUTTON_LOCATOR = "//input[@class=\"glossyButton\" and @value=\"LABEL\"]";

    public AbstractWizardPage(WebDriver driver) {
        super(driver);
    }

    public String getTitle() {
        WebElement title = AbstractWizardPage.findElementWithTimeout(By.xpath((String)"//h1"));
        return title.getText().trim();
    }

    protected abstract String getNextButtonLocator();

    protected abstract String getPreviousButtonLocator();

    public <T extends AbstractWizardPage> T next(Class<T> wizardPageClass) {
        WebElement buttonNext = AbstractWizardPage.findElementWithTimeout(By.xpath((String)this.getNextButtonLocator()));
        buttonNext.click();
        return (T)((AbstractWizardPage)this.asPage(wizardPageClass));
    }

    public <T extends AbstractWizardPage> T previous(Class<T> wizardPageClass) {
        WebElement buttonPrev = AbstractWizardPage.findElementWithTimeout(By.xpath((String)this.getPreviousButtonLocator()));
        buttonPrev.click();
        return (T)((AbstractWizardPage)this.asPage(wizardPageClass));
    }

    public <T extends AbstractPage> T nav(Class<T> wizardPageClass, String buttonLabel) {
        WebElement button = this.findNavButton(buttonLabel);
        if (button == null) {
            return null;
        }
        button.click();
        return (T)((AbstractPage)this.asPage(wizardPageClass));
    }

    public <T extends AbstractPage> T navByLink(Class<T> wizardPageClass, String linkLabel) {
        WebElement link = AbstractWizardPage.findElementWithTimeout(By.linkText((String)linkLabel));
        if (link == null) {
            return null;
        }
        link.click();
        return (T)((AbstractPage)this.asPage(wizardPageClass));
    }

    public <T extends AbstractPage> T navById(Class<T> wizardPageClass, String buttonId) {
        WebElement button = AbstractWizardPage.findElementWithTimeout(By.id((String)buttonId));
        if (button == null) {
            return null;
        }
        button.click();
        return (T)((AbstractPage)this.asPage(wizardPageClass));
    }

    protected WebElement findNavButton(String label) {
        return AbstractWizardPage.findElementWithTimeout(By.xpath((String)BUTTON_LOCATOR.replace("LABEL", label)));
    }

    public boolean fillInput(String name, String value) {
        WebElement element = AbstractWizardPage.findElementWithTimeout(By.name((String)name));
        if (element != null) {
            element.clear();
            element.sendKeys(new CharSequence[]{value});
            return true;
        }
        return false;
    }

    public boolean selectOption(String name, String value) {
        WebElement element = AbstractWizardPage.findElementWithTimeout(By.name((String)name));
        if (element != null) {
            Select select = new Select(element);
            select.selectByValue(value);
            return select.getFirstSelectedOption().getValue().equals(value);
        }
        return false;
    }

    public boolean clearInput(String name) {
        WebElement element = AbstractWizardPage.findElementWithTimeout(By.name((String)name));
        if (element != null) {
            element.clear();
            return true;
        }
        return false;
    }
}

