/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriverException;

public class ScreenShotFileOutput
implements OutputType<File> {
    String screenshotFilePrefix;

    public ScreenShotFileOutput(String screenshotFilePrefix) {
        this.screenshotFilePrefix = screenshotFilePrefix;
    }

    public File convertFromBase64Png(String base64Png) {
        byte[] data = (byte[])BYTES.convertFromBase64Png(base64Png);
        return this.convertFromPngBytes(data);
    }

    public File convertFromPngBytes(byte[] data) {
        FileOutputStream fos = null;
        String location = System.getProperty("basedir") + File.separator + "target";
        try {
            File outputFolder = null;
            if (!(location == null || (outputFolder = new File(location)).exists() && outputFolder.isDirectory())) {
                outputFolder = null;
            }
            File tmpFile = File.createTempFile(this.screenshotFilePrefix, ".png", outputFolder);
            fos = new FileOutputStream(tmpFile);
            fos.write(data);
            fos.close();
            File file = tmpFile;
            return file;
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

