/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.ScreenShotFileOutput;
import org.nuxeo.functionaltests.VariableElementLocatorFactory;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.LoginPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.ui.SystemClock;

public abstract class AbstractTest {
    public static final String NUXEO_URL = "http://localhost:8080/nuxeo";
    private static final String FIREBUG_XPI = "firebug-1.6.2-fx.xpi";
    private static final String FIREBUG_VERSION = "1.6.2";
    private static final String FIREBUG_M2 = "firebug/firebug/1.6.2-fx";
    private static final String M2_REPO = "/.m2/repository/";
    private static final int LOAD_TIMEOUT_SECONDS = 30;
    private static final int AJAX_TIMEOUT_SECONDS = 10;
    protected static FirefoxDriver driver;
    protected static File tmp_firebug_xpi;

    @BeforeClass
    public static void initDriver() throws Exception {
        FirefoxProfile profile = new FirefoxProfile();
        profile.setEnableNativeEvents(false);
        profile.setPreference("general.useragent.locale", "en");
        profile.setPreference("intl.accept_languages", "en");
        profile.setPreference("general.useragent.override", "Mozilla/5.0 Nuxeo-Selenium-Tester");
        AbstractTest.addFireBug(profile);
        driver = new FirefoxDriver(profile);
    }

    @AfterClass
    public static void quitDriver() throws InterruptedException {
        Thread.sleep(250L);
        driver.getScreenshotAs((OutputType)new ScreenShotFileOutput("screenshot1-lastpage"));
        Thread.sleep(250L);
        driver.getScreenshotAs((OutputType)new ScreenShotFileOutput("screenshot2-lastpage"));
        if (driver != null) {
            driver.close();
            driver = null;
        }
        AbstractTest.removeFireBug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> getClassLoaderFiles() throws Exception {
        URL[] urls;
        block14: {
            ClassLoader cl = AbstractTest.class.getClassLoader();
            urls = null;
            if (cl instanceof URLClassLoader) {
                urls = ((URLClassLoader)cl).getURLs();
            } else if (cl.getClass().getName().equals("org.apache.tools.ant.AntClassLoader")) {
                Method method = cl.getClass().getMethod("getClasspath", new Class[0]);
                String cp = (String)method.invoke((Object)cl, new Object[0]);
                String[] paths = cp.split(File.pathSeparator);
                urls = new URL[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    urls[i] = new URL("file:" + paths[i]);
                }
            } else {
                System.err.println("Unknow classloader type: " + cl.getClass().getName());
                return null;
            }
            if (urls.length == 1) {
                try {
                    URI uri = urls[0].toURI();
                    if (!uri.getScheme().equals("file") || !uri.getPath().contains("surefirebooter")) break block14;
                    JarFile jar = new JarFile(new File(uri));
                    try {
                        String cp = jar.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                        if (cp != null) {
                            String[] cpe = cp.split(" ");
                            URL[] newUrls = new URL[cpe.length];
                            for (int i = 0; i < cpe.length; ++i) {
                                String newUrl = cpe[i].startsWith("file:") ? cpe[i] : "file:" + cpe[i];
                                newUrls[i] = new URL(newUrl);
                            }
                            urls = newUrls;
                        }
                    }
                    finally {
                        jar.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        ArrayList<String> files = new ArrayList<String>(urls.length);
        for (URL url : urls) {
            files.add(url.toURI().getPath());
        }
        return files;
    }

    protected static void addFireBug(FirefoxProfile profile) throws Exception {
        File xpi = null;
        List<String> clf = AbstractTest.getClassLoaderFiles();
        for (String f : clf) {
            if (!f.endsWith("/firebug-1.6.2-fx.xpi")) continue;
            xpi = new File(f);
        }
        if (xpi == null) {
            String customM2Repo = System.getProperty("M2_REPO", M2_REPO);
            for (String f : clf) {
                if (!f.contains(customM2Repo)) continue;
                String m2 = f.substring(0, f.indexOf(customM2Repo) + customM2Repo.length());
                xpi = new File(m2 + FIREBUG_M2 + "/" + FIREBUG_XPI);
                break;
            }
        }
        if (xpi == null || !xpi.exists()) {
            throw new RuntimeException("firebug-1.6.2-fx.xpi not found in classloader or local M2 repository");
        }
        profile.addExtension(xpi);
        profile.setPreference("extensions.firebug.currentVersion", FIREBUG_VERSION);
    }

    protected static void removeFireBug() {
        if (tmp_firebug_xpi != null) {
            tmp_firebug_xpi.delete();
            tmp_firebug_xpi.getParentFile().delete();
        }
    }

    public static <T> T get(String url, Class<T> pageClassToProxy) {
        driver.get(url);
        return AbstractTest.asPage(pageClassToProxy);
    }

    public static <T> T asPage(Class<T> pageClassToProxy) {
        T page = AbstractTest.instantiatePage((WebDriver)driver, pageClassToProxy);
        PageFactory.initElements((ElementLocatorFactory)new VariableElementLocatorFactory((WebDriver)driver, 10), page);
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<WrapsElement> elements = new ArrayList<WrapsElement>();
        for (Field field : pageClassToProxy.getDeclaredFields()) {
            if (field.getAnnotation(Required.class) == null) continue;
            try {
                field.setAccessible(true);
                fieldNames.add(field.getName());
                elements.add((WrapsElement)field.get(page));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        SystemClock clock = new SystemClock();
        long end = clock.laterBy(TimeUnit.SECONDS.toMillis(30L));
        String notLoaded = null;
        while (clock.isNowBefore(end)) {
            notLoaded = AbstractTest.anyElementNotLoaded(elements, fieldNames);
            if (notLoaded == null) {
                return page;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        throw new NoSuchElementException("Timeout loading page " + pageClassToProxy.getSimpleName() + " missing element " + notLoaded);
    }

    protected static String anyElementNotLoaded(List<WrapsElement> proxies, List<String> fieldNames) {
        for (int i = 0; i < proxies.size(); ++i) {
            WrapsElement proxy = proxies.get(i);
            try {
                proxy.getWrappedElement();
                continue;
            }
            catch (NoSuchElementException e) {
                return fieldNames.get(i);
            }
        }
        return null;
    }

    protected static <T> T instantiatePage(WebDriver driver, Class<T> pageClassToProxy) {
        try {
            try {
                Constructor<T> constructor = pageClassToProxy.getConstructor(WebDriver.class);
                return constructor.newInstance(driver);
            }
            catch (NoSuchMethodException e) {
                return pageClassToProxy.newInstance();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static WebElement findElementWithTimeout(By by, int timeout) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, timeout, null);
    }

    public static WebElement findElementWithTimeout(By by, int timeout, WebElement parentElement) throws NoSuchElementException {
        SystemClock clock = new SystemClock();
        long end = clock.laterBy((long)timeout);
        NoSuchElementException lastException = null;
        while (clock.isNowBefore(end)) {
            try {
                WebElement element = parentElement == null ? driver.findElement(by) : parentElement.findElement(by);
                if (element != null) {
                    return element;
                }
            }
            catch (NoSuchElementException e) {
                lastException = e;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        throw new NoSuchElementException(String.format("Couldn't find element '%s' after timeout", by), (Throwable)lastException);
    }

    public static WebElement findElementWithTimeout(By by) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, 30000);
    }

    public static WebElement findElementWithTimeout(By by, WebElement parentElement) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, 30000, parentElement);
    }

    public static void waitUntilEnabled(WebElement element, int timeout) throws NotFoundException {
        SystemClock clock = new SystemClock();
        long end = clock.laterBy((long)timeout);
        while (clock.isNowBefore(end)) {
            if (element.isEnabled()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        throw new NotFoundException("Element not enabled after timeout: " + element);
    }

    public static void waitUntilEnabled(WebElement element) throws NotFoundException {
        AbstractTest.waitUntilEnabled(element, 10000);
    }

    public LoginPage getLoginPage() {
        return AbstractTest.get(NUXEO_URL, LoginPage.class);
    }

    public <T extends AbstractPage> T nav(Class<T> pageClass, String linkText) {
        WebElement link = AbstractTest.findElementWithTimeout(By.linkText((String)linkText));
        if (link == null) {
            return null;
        }
        link.click();
        return (T)((AbstractPage)AbstractTest.asPage(pageClass));
    }

    public DocumentBasePage login() throws DocumentBasePage.UserNotConnectedException {
        return this.login("Administrator", "Administrator");
    }

    public DocumentBasePage login(String username, String password) throws DocumentBasePage.UserNotConnectedException {
        DocumentBasePage documentBasePage = this.getLoginPage().login(username, password, DocumentBasePage.class);
        documentBasePage.checkUserConnected(username);
        return documentBasePage;
    }

    public LoginPage loginInvalid(String username, String password) {
        LoginPage loginPage = this.getLoginPage().login(username, password, LoginPage.class);
        return loginPage;
    }
}

