/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.wizard;

import org.nuxeo.functionaltests.pages.AbstractPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public abstract class AbstractWizardPage
extends AbstractPage {
    protected static final String BUTTON_LOCATOR = "//input[@class=\"glossyButton\" and @value=\"LABEL\"]";

    public AbstractWizardPage(WebDriver driver) {
        super(driver);
    }

    public String getTitle() {
        WebElement title = AbstractWizardPage.findElementWithTimeout(By.xpath((String)"//h1"));
        return title.getText().trim();
    }

    protected abstract String getNextButtonLocator();

    protected abstract String getPreviousButtonLocator();

    public <T extends AbstractWizardPage> T next(Class<T> wizardPageClass) {
        return this.next(wizardPageClass, false);
    }

    public <T extends AbstractWizardPage> T next(Class<T> wizardPageClass, Boolean waitForURLChange) {
        WebElement buttonNext = AbstractWizardPage.findElementWithTimeout(By.xpath((String)this.getNextButtonLocator()));
        String URLbefore = this.driver.getCurrentUrl();
        buttonNext.click();
        if (waitForURLChange.booleanValue()) {
            this.waitUntilURLDifferentFrom(URLbefore);
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return (T)((AbstractWizardPage)this.asPage(wizardPageClass));
    }

    public <T extends AbstractWizardPage> T previous(Class<T> wizardPageClass) {
        return this.previous(wizardPageClass, false);
    }

    public <T extends AbstractWizardPage> T previous(Class<T> wizardPageClass, Boolean waitForURLChange) {
        WebElement buttonPrev = AbstractWizardPage.findElementWithTimeout(By.xpath((String)this.getPreviousButtonLocator()));
        String URLbefore = this.driver.getCurrentUrl();
        buttonPrev.click();
        if (waitForURLChange.booleanValue()) {
            this.waitUntilURLDifferentFrom(URLbefore);
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return (T)((AbstractWizardPage)this.asPage(wizardPageClass));
    }

    public <T extends AbstractPage> T nav(Class<T> wizardPageClass, String buttonLabel) {
        return this.nav(wizardPageClass, buttonLabel, false);
    }

    public <T extends AbstractPage> T nav(Class<T> wizardPageClass, String buttonLabel, Boolean waitForURLChange) {
        WebElement button = this.findNavButton(buttonLabel);
        if (button == null) {
            return null;
        }
        String URLbefore = this.driver.getCurrentUrl();
        button.click();
        if (waitForURLChange.booleanValue()) {
            this.waitUntilURLDifferentFrom(URLbefore);
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return (T)((AbstractPage)this.asPage(wizardPageClass));
    }

    public <T extends AbstractPage> T navByLink(Class<T> wizardPageClass, String linkLabel) {
        return this.navByLink(wizardPageClass, linkLabel, false);
    }

    public <T extends AbstractPage> T navByLink(Class<T> wizardPageClass, String linkLabel, Boolean waitForURLChange) {
        WebElement link = AbstractWizardPage.findElementWithTimeout(By.linkText((String)linkLabel));
        if (link == null) {
            return null;
        }
        String URLbefore = this.driver.getCurrentUrl();
        link.click();
        if (waitForURLChange.booleanValue()) {
            this.waitUntilURLDifferentFrom(URLbefore);
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return (T)((AbstractPage)this.asPage(wizardPageClass));
    }

    public <T extends AbstractPage> T navById(Class<T> wizardPageClass, String buttonId) {
        return this.navById(wizardPageClass, buttonId, false);
    }

    public <T extends AbstractPage> T navById(Class<T> wizardPageClass, String buttonId, Boolean waitForURLChange) {
        WebElement button = AbstractWizardPage.findElementWithTimeout(By.id((String)buttonId));
        if (button == null) {
            return null;
        }
        String URLbefore = this.driver.getCurrentUrl();
        button.click();
        if (waitForURLChange.booleanValue()) {
            this.waitUntilURLDifferentFrom(URLbefore);
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return (T)((AbstractPage)this.asPage(wizardPageClass));
    }

    protected WebElement findNavButton(String label) {
        return AbstractWizardPage.findElementWithTimeout(By.xpath((String)BUTTON_LOCATOR.replace("LABEL", label)));
    }

    public boolean fillInput(String name, String value) {
        WebElement element = AbstractWizardPage.findElementWithTimeout(By.name((String)name));
        if (element != null) {
            element.clear();
            element.sendKeys(new CharSequence[]{value});
            return true;
        }
        return false;
    }

    public boolean selectOption(String name, String value) {
        WebElement element = AbstractWizardPage.findElementWithTimeout(By.name((String)name));
        if (element != null) {
            Select select = new Select(element);
            select.selectByValue(value);
            return select.getFirstSelectedOption().getAttribute("value").equals(value);
        }
        return false;
    }

    public boolean clearInput(String name) {
        WebElement element = AbstractWizardPage.findElementWithTimeout(By.name((String)name));
        if (element != null) {
            element.clear();
            return true;
        }
        return false;
    }
}

