/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import com.google.common.base.Function;
import org.junit.Assert;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.pages.HeaderLinksSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class AbstractPage {
    public static int URLCHANGE_MAX_WAIT = 10;
    @FindBy(name="userServicesForm")
    public WebElement userServicesForm;
    protected WebDriver driver;

    public AbstractPage(WebDriver driver) {
        this.driver = driver;
    }

    public <T> T get(String url, Class<T> pageClassToProxy) {
        return AbstractTest.get(url, pageClassToProxy);
    }

    public <T> T asPage(Class<T> pageClassToProxy) {
        return AbstractTest.asPage(pageClassToProxy);
    }

    public String getFeedbackMessage() {
        String ret;
        try {
            ret = AbstractPage.findElementWithTimeout(By.xpath((String)"//li[@class=\"errorFeedback\"]")).getText();
        }
        catch (NoSuchElementException e) {
            ret = "";
        }
        return ret.trim();
    }

    public HeaderLinksSubPage getHeaderLinks() {
        Assert.assertNotNull((Object)this.userServicesForm);
        return this.asPage(HeaderLinksSubPage.class);
    }

    public WebElement findElementWithTimeout(By by, int timeout) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, timeout);
    }

    public WebElement findElementWithTimeout(By by, int timeout, WebElement parentElement) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, timeout, parentElement);
    }

    public static WebElement findElementWithTimeout(By by) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by);
    }

    public static WebElement findElementWithTimeout(By by, WebElement parentElement) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, parentElement);
    }

    public static void waitUntilEnabled(WebElement element, int timeout) throws NotFoundException {
        AbstractTest.waitUntilEnabled(element, timeout);
    }

    public static void waitUntilEnabled(WebElement element) throws NotFoundException {
        AbstractTest.waitUntilEnabled(element);
    }

    public void waitUntilURLDifferentFrom(String url) {
        final String refurl = url;
        ExpectedCondition<Boolean> urlchanged = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                return !d.getCurrentUrl().equals(refurl);
            }
        };
        WebDriverWait wait = new WebDriverWait(this.driver, (long)URLCHANGE_MAX_WAIT);
        wait.until((Function)urlchanged);
        if (this.driver.getCurrentUrl().equals(refurl)) {
            System.out.println("Page change failed");
        }
    }
}

