/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.util.List;
import org.junit.Assert;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class ContentTabSubPage
extends DocumentBasePage {
    private static final String DELETE_BUTTON_XPATH = "//input[@value=\"Delete\"]";
    @Required
    @FindBy(id="document_content")
    WebElement documentContentForm;
    @FindBy(linkText="New")
    WebElement newButton;

    public ContentTabSubPage(WebDriver driver) {
        super(driver);
    }

    public DocumentBasePage goToDocument(String documentTitle) {
        this.documentContentForm.findElement(By.linkText((String)documentTitle)).click();
        return this.asPage(DocumentBasePage.class);
    }

    public <T> T getDocumentCreatePage(String docType, Class<T> pageClassToProxy) {
        this.newButton.click();
        WebElement link = null;
        for (WebElement element : this.driver.findElements(By.className((String)"documentType"))) {
            try {
                link = element.findElement(By.linkText((String)docType));
                break;
            }
            catch (NoSuchElementException e) {
            }
        }
        Assert.assertNotNull(link);
        link.click();
        return this.asPage(pageClassToProxy);
    }

    public DocumentBasePage removeDocument(String documentTitle) {
        List trelements = this.documentContentForm.findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr"));
        for (WebElement trItem : trelements) {
            try {
                trItem.findElement(By.linkText((String)documentTitle));
                WebElement checkBox = trItem.findElement(By.xpath((String)"td/input[@type=\"checkbox\"]"));
                checkBox.click();
                break;
            }
            catch (NoSuchElementException e) {
            }
        }
        ContentTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)DELETE_BUTTON_XPATH));
        Alert alert = this.driver.switchTo().alert();
        Assert.assertEquals((Object)"Delete selected document(s)?", (Object)alert.getText());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        alert.accept();
        return this.asPage(DocumentBasePage.class);
    }
}

