/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.NavigationSubPage;
import org.nuxeo.functionaltests.pages.actions.ContextualActions;
import org.nuxeo.functionaltests.pages.admincenter.AdminCenterBasePage;
import org.nuxeo.functionaltests.pages.tabs.ContentTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.EditTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.HistoryTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.ManageTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.SummaryTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.WorkspacesContentTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class DocumentBasePage
extends AbstractPage {
    @Required
    @FindBy(xpath="//div[@class=\"tabsBar\"]")
    public WebElement tabsBar;
    @FindBy(xpath="//div[@class=\"tabsBar\"]/form/ul/li/a[text()=\"Content\"]")
    public WebElement contentTabLink;
    @FindBy(xpath="//div[@class=\"tabsBar\"]/form/ul/li/a[text()=\"Summary\"]")
    public WebElement summaryTabLink;
    @FindBy(xpath="//div[@class=\"tabsBar\"]/form/ul/li/a[text()=\"Edit\"]")
    public WebElement editTabLink;
    @FindBy(xpath="//div[@class=\"tabsBar\"]/form/ul/li/a[text()=\"History\"]")
    public WebElement historyTabLink;
    @FindBy(xpath="//div[@class=\"tabsBar\"]/form/ul/li/a[text()=\"Manage\"]")
    public WebElement manageTabLink;
    @FindBy(className="documentDescription")
    public WebElement currentDocumentDescription;
    @FindBy(className="currentDocumentDescription")
    public WebElement currentFolderishDescription;
    @FindBy(xpath="/html/body/table[2]/tbody/tr/td[2]/div[2]//h1")
    public WebElement currentDocumentTitle;
    @FindBy(xpath="//form[@id=\"breadcrumbForm\"]")
    public WebElement breadcrumbForm;
    @FindBy(className="creator")
    public WebElement currentDocumentContributor;
    public ContextualActions contextualActions;

    public DocumentBasePage(WebDriver driver) {
        super(driver);
    }

    public ContentTabSubPage getContentTab() {
        this.clickOnLinkIfNotSelected(this.contentTabLink);
        return this.asPage(ContentTabSubPage.class);
    }

    public EditTabSubPage getEditTab() {
        this.clickOnLinkIfNotSelected(this.editTabLink);
        return this.asPage(EditTabSubPage.class);
    }

    public SummaryTabSubPage getSummaryTab() {
        this.clickOnLinkIfNotSelected(this.summaryTabLink);
        return this.asPage(SummaryTabSubPage.class);
    }

    public HistoryTabSubPage getHistoryTab() {
        this.clickOnLinkIfNotSelected(this.historyTabLink);
        return this.asPage(HistoryTabSubPage.class);
    }

    public ManageTabSubPage getManageTab() {
        this.clickOnLinkIfNotSelected(this.manageTabLink);
        return this.asPage(ManageTabSubPage.class);
    }

    public NavigationSubPage getNavigationSubPage() {
        return this.asPage(NavigationSubPage.class);
    }

    protected void clickOnLinkIfNotSelected(WebElement tabLink) {
        WebElement selectedTab = DocumentBasePage.findElementWithTimeout(By.xpath((String)"/html/body/table[2]/tbody/tr/td[2]/div[2]//div[@class=\"tabsBar\"]/form/ul/li[@class=\"selected\"]/a"));
        if (!selectedTab.equals(tabLink)) {
            tabLink.click();
        }
    }

    public WorkspacesContentTabSubPage getWorkspacesContentTab() {
        this.clickOnLinkIfNotSelected(this.contentTabLink);
        return this.asPage(WorkspacesContentTabSubPage.class);
    }

    public void checkUserConnected(String username) throws UserNotConnectedException {
        if (!this.getHeaderLinks().getText().contains(username)) {
            throw new UserNotConnectedException(username);
        }
    }

    public void checkDocTitle(String expectedTitle) {
        Assert.assertEquals((Object)expectedTitle, (Object)this.getCurrentDocumentTitle());
    }

    public String getCurrentDocumentDescription() {
        return this.currentDocumentDescription.getText();
    }

    public String getCurrentFolderishDescription() {
        return this.currentFolderishDescription.getText();
    }

    public String getCurrentDocumentTitle() {
        return this.currentDocumentTitle.getText();
    }

    public List<String> getCurrentStates() {
        List<WebElement> states = DocumentBasePage.findElementsWithTimeout(By.className((String)"sticker"));
        ArrayList<String> stateLabels = new ArrayList<String>();
        for (WebElement state : states) {
            stateLabels.add(state.getText());
        }
        return stateLabels;
    }

    public String getCurrentContributors() {
        return this.currentDocumentContributor.getText();
    }

    public DocumentBasePage goToDocumentByBreadcrumb(String documentTitle) {
        this.breadcrumbForm.findElement(By.linkText((String)documentTitle)).click();
        return this.asPage(DocumentBasePage.class);
    }

    public AdminCenterBasePage getAdminCenter() {
        DocumentBasePage.findElementWithTimeout(By.linkText((String)"Admin Center")).click();
        return this.asPage(AdminCenterBasePage.class);
    }

    public ContextualActions getContextualActions() {
        return this.asPage(ContextualActions.class);
    }

    public class UserNotConnectedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UserNotConnectedException(String username) {
            super("The user " + username + " is expected to be connected but isn't");
        }
    }
}

