/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import java.util.List;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

public class LoginPage
extends AbstractPage {
    @Required
    @FindBy(id="username")
    WebElement usernameInputTextBox;
    @Required
    @FindBy(id="password")
    WebElement passwordInputTextBox;
    @Required
    @FindBy(name="Submit")
    WebElement submitButton;
    @Deprecated
    @FindBy(id="language")
    WebElement languageSelectBox;

    public LoginPage(WebDriver driver) {
        super(driver);
    }

    public void login(String username, String password, String language) {
        this.usernameInputTextBox.sendKeys(new CharSequence[]{username});
        this.passwordInputTextBox.sendKeys(new CharSequence[]{password});
        if (language != null) {
            Select languageSelect = new Select(this.languageSelectBox);
            List list = languageSelect.getOptions();
            for (WebElement webElement : list) {
                if (!language.trim().equals(webElement.getText().trim())) continue;
                languageSelect.selectByVisibleText(webElement.getText());
                break;
            }
        }
        this.submitButton.click();
    }

    public void login(String username, String password) {
        this.login(username, password, (String)null);
    }

    public <T> T login(String username, String password, Class<T> pageClassToProxy) {
        this.login(username, password);
        return this.asPage(pageClassToProxy);
    }
}

