/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.browsermob.proxy.ProxyServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.rules.TestWatchman;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.ScreenShotFileOutput;
import org.nuxeo.functionaltests.VariableElementLocatorFactory;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.FileDocumentBasePage;
import org.nuxeo.functionaltests.pages.LoginPage;
import org.nuxeo.functionaltests.pages.forms.FileCreationFormPage;
import org.nuxeo.functionaltests.pages.forms.WorkspaceFormPage;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.SystemClock;

public abstract class AbstractTest {
    private static final Log log = LogFactory.getLog(AbstractTest.class);
    public static final String NUXEO_URL = System.getProperty("nuxeoURL", "http://localhost:8080/nuxeo").replaceAll("/$", "");
    public static final int LOAD_TIMEOUT_SECONDS = 30;
    public static final int LOAD_SHORT_TIMEOUT_SECONDS = 2;
    public static final int AJAX_TIMEOUT_SECONDS = 10;
    public static final int AJAX_SHORT_TIMEOUT_SECONDS = 2;
    private static final String FIREBUG_XPI = "firebug-1.6.2-fx.xpi";
    private static final String FIREBUG_VERSION = "1.6.2";
    private static final String FIREBUG_M2 = "firebug/firebug/1.6.2-fx";
    private static final int PROXY_PORT = 4444;
    private static final String HAR_NAME = "http-headers.json";
    protected static RemoteWebDriver driver;
    protected static File tmp_firebug_xpi;
    protected static ProxyServer proxyServer;
    @Rule
    public MethodRule watchman = new TestWatchman(){

        public void starting(FrameworkMethod method) {
            String message = String.format("Starting test '%s#%s'", this.getTestClassName(method), method.getName());
            log.info((Object)message);
            this.logOnServer(message);
        }

        public void failed(Throwable e, FrameworkMethod method) {
            String className = this.getTestClassName(method);
            String methodName = method.getName();
            log.error((Object)String.format("Test '%s#%s' failed", className, methodName), e);
            String filename = String.format("screenshot-lastpage-%s-%s", className, methodName);
            this.takeScreenshot(filename);
            super.failed(e, method);
        }

        public void finished(FrameworkMethod method) {
            log.info((Object)String.format("Finished test '%s#%s'", this.getTestClassName(method), method.getName()));
            super.finished(method);
        }

        protected String getTestClassName(FrameworkMethod method) {
            return method.getMethod().getDeclaringClass().getName();
        }

        protected void logOnServer(String message) {
            if (driver != null) {
                driver.get(String.format("%s/restAPI/systemLog?token=dolog&level=WARN&message=----- WebDriver: %s", NUXEO_URL, URIUtils.quoteURIPathComponent((String)message, (boolean)true)));
            } else {
                log.warn((Object)String.format("Cannot log on server message: %s", message));
            }
        }

        protected void takeScreenshot(String filename) {
            if (driver instanceof FirefoxDriver) {
                try {
                    Thread.sleep(250L);
                    ((FirefoxDriver)driver).getScreenshotAs((OutputType)new ScreenShotFileOutput(filename));
                }
                catch (InterruptedException ee) {
                    log.error((Object)ee, (Throwable)ee);
                }
            }
        }
    };
    private static final String M2_REPO = "repository/";

    @BeforeClass
    public static void initDriver() throws Exception {
        String browser = System.getProperty("browser", "firefox");
        if (browser.equals("chrome") || browser.equals("firefox")) {
            AbstractTest.initFirefoxDriver();
        } else if (browser.equals("googlechrome")) {
            AbstractTest.initChromeDriver();
        } else {
            throw new RuntimeException("Browser not supported: " + browser);
        }
    }

    protected static void initFirefoxDriver() throws Exception {
        DesiredCapabilities dc = DesiredCapabilities.firefox();
        FirefoxProfile profile = new FirefoxProfile();
        profile.setEnableNativeEvents(false);
        profile.setPreference("general.useragent.locale", "en");
        profile.setPreference("intl.accept_languages", "en");
        AbstractTest.addFireBug(profile);
        Proxy proxy = AbstractTest.startProxy();
        if (proxy != null) {
            proxy.setNoProxy("");
            profile.setProxyPreferences(proxy);
        }
        dc.setCapability("firefox_profile", (Object)profile);
        driver = new FirefoxDriver((Capabilities)dc);
    }

    protected static void initChromeDriver() throws Exception {
        DesiredCapabilities dc = DesiredCapabilities.chrome();
        ChromeOptions options = new ChromeOptions();
        options.addArguments(Arrays.asList("--ignore-certificate-errors"));
        Proxy proxy = AbstractTest.startProxy();
        if (proxy != null) {
            proxy.setNoProxy("");
            dc.setCapability("proxy", (Object)proxy);
        }
        dc.setCapability("chromeOptions", (Object)options);
        driver = new ChromeDriver((Capabilities)dc);
    }

    @AfterClass
    public static void quitDriver() throws InterruptedException {
        if (driver != null) {
            driver.close();
            driver = null;
        }
        AbstractTest.removeFireBug();
        try {
            AbstractTest.stopProxy();
        }
        catch (Exception e) {
            System.err.println("Could not stop proxy: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> getClassLoaderFiles() throws Exception {
        URL[] urls;
        block14: {
            ClassLoader cl = AbstractTest.class.getClassLoader();
            urls = null;
            if (cl instanceof URLClassLoader) {
                urls = ((URLClassLoader)cl).getURLs();
            } else if (cl.getClass().getName().equals("org.apache.tools.ant.AntClassLoader")) {
                Method method = cl.getClass().getMethod("getClasspath", new Class[0]);
                String cp = (String)method.invoke((Object)cl, new Object[0]);
                String[] paths = cp.split(File.pathSeparator);
                urls = new URL[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    urls[i] = new URL("file:" + paths[i]);
                }
            } else {
                System.err.println("Unknown classloader type: " + cl.getClass().getName());
                return null;
            }
            if (urls.length == 1) {
                try {
                    URI uri = urls[0].toURI();
                    if (!uri.getScheme().equals("file") || !uri.getPath().contains("surefirebooter")) break block14;
                    JarFile jar = new JarFile(new File(uri));
                    try {
                        String cp = jar.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                        if (cp != null) {
                            String[] cpe = cp.split(" ");
                            URL[] newUrls = new URL[cpe.length];
                            for (int i = 0; i < cpe.length; ++i) {
                                String newUrl = cpe[i].startsWith("file:") ? cpe[i] : "file:" + cpe[i];
                                newUrls[i] = new URL(newUrl);
                            }
                            urls = newUrls;
                        }
                    }
                    finally {
                        jar.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        ArrayList<String> files = new ArrayList<String>(urls.length);
        for (URL url : urls) {
            files.add(url.toURI().getPath());
        }
        return files;
    }

    protected static void addFireBug(FirefoxProfile profile) throws Exception {
        File xpi = null;
        List<String> clf = AbstractTest.getClassLoaderFiles();
        for (String f : clf) {
            if (!f.endsWith("/firebug-1.6.2-fx.xpi")) continue;
            xpi = new File(f);
        }
        if (xpi == null) {
            String customM2Repo = System.getProperty("M2_REPO", M2_REPO).replaceAll("/$", "");
            for (String f : clf) {
                if (!f.contains(customM2Repo)) continue;
                String m2 = f.substring(0, f.indexOf(customM2Repo) + customM2Repo.length());
                xpi = new File(m2 + "/" + FIREBUG_M2 + "/" + FIREBUG_XPI);
                break;
            }
        }
        if (xpi == null || !xpi.exists()) {
            throw new RuntimeException("firebug-1.6.2-fx.xpi not found in classloader or local M2 repository");
        }
        profile.addExtension(xpi);
        profile.setPreference("extensions.firebug.currentVersion", FIREBUG_VERSION);
    }

    protected static void removeFireBug() {
        if (tmp_firebug_xpi != null) {
            tmp_firebug_xpi.delete();
            tmp_firebug_xpi.getParentFile().delete();
        }
    }

    protected static Proxy startProxy() throws Exception {
        if (Boolean.TRUE.equals(Boolean.valueOf(System.getProperty("useProxy", "false")))) {
            proxyServer = new ProxyServer(4444);
            proxyServer.start();
            proxyServer.setCaptureHeaders(true);
            proxyServer.blacklistRequests("https?://www\\.nuxeo\\.com/embedded/wizard.*", 410);
            proxyServer.blacklistRequests("https?://.*\\.mktoresp\\.com/.*", 410);
            proxyServer.blacklistRequests(".*_mchId.*", 410);
            proxyServer.blacklistRequests("https?://.*\\.google-analytics\\.com/.*", 410);
            proxyServer.newHar("webdriver-test");
            Proxy proxy = proxyServer.seleniumProxy();
            return proxy;
        }
        return null;
    }

    protected static void stopProxy() throws Exception {
        if (proxyServer != null) {
            String target = System.getProperty("nuxeo.log.dir");
            File harFile = target == null ? new File(HAR_NAME) : new File(target, HAR_NAME);
            proxyServer.getHar().writeTo(harFile);
            proxyServer.stop();
        }
    }

    public static <T> T get(String url, Class<T> pageClassToProxy) {
        driver.get(url);
        return AbstractTest.asPage(pageClassToProxy);
    }

    public static <T> T asPage(Class<T> pageClassToProxy) {
        T page = AbstractTest.instantiatePage(pageClassToProxy);
        PageFactory.initElements((ElementLocatorFactory)new VariableElementLocatorFactory((WebDriver)driver, 10), page);
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<WrapsElement> elements = new ArrayList<WrapsElement>();
        for (Field field : pageClassToProxy.getDeclaredFields()) {
            if (field.getAnnotation(Required.class) == null) continue;
            try {
                field.setAccessible(true);
                fieldNames.add(field.getName());
                elements.add((WrapsElement)field.get(page));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        SystemClock clock = new SystemClock();
        long end = clock.laterBy(TimeUnit.SECONDS.toMillis(30L));
        String notLoaded = null;
        while (clock.isNowBefore(end)) {
            notLoaded = AbstractTest.anyElementNotLoaded(elements, fieldNames);
            if (notLoaded == null) {
                return page;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        throw new NoSuchElementException("Timeout loading page " + pageClassToProxy.getSimpleName() + " missing element " + notLoaded);
    }

    protected static String anyElementNotLoaded(List<WrapsElement> proxies, List<String> fieldNames) {
        for (int i = 0; i < proxies.size(); ++i) {
            WrapsElement proxy = proxies.get(i);
            try {
                proxy.getWrappedElement();
                continue;
            }
            catch (NoSuchElementException e) {
                return fieldNames.get(i);
            }
        }
        return null;
    }

    protected static <T> T instantiatePage(Class<T> pageClassToProxy) {
        try {
            try {
                Constructor<T> constructor = pageClassToProxy.getConstructor(WebDriver.class);
                return constructor.newInstance(driver);
            }
            catch (NoSuchMethodException e) {
                return pageClassToProxy.newInstance();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static WebElement findElementWithTimeout(By by, int timeout) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, timeout, null);
    }

    public static WebElement findElementWithTimeout(By by, int timeout, WebElement parentElement) throws NoSuchElementException {
        SystemClock clock = new SystemClock();
        long end = clock.laterBy((long)timeout);
        NoSuchElementException lastException = null;
        while (clock.isNowBefore(end)) {
            try {
                WebElement element = parentElement == null ? driver.findElement(by) : parentElement.findElement(by);
                if (element != null) {
                    return element;
                }
            }
            catch (NoSuchElementException e) {
                lastException = e;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        throw new NoSuchElementException(String.format("Couldn't find element '%s' after timeout", by), (Throwable)lastException);
    }

    public static WebElement findElementWithTimeout(By by) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, 30000);
    }

    public static List<WebElement> findElementsWithTimeout(By by) throws NoSuchElementException {
        return driver.findElements(by);
    }

    public WebElement waitUntilElementPresent(final By locator) {
        FluentWait wait = new FluentWait((Object)driver).withTimeout(30L, TimeUnit.SECONDS).pollingEvery(5L, TimeUnit.SECONDS).ignoring(NoSuchElementException.class);
        WebElement elt = (WebElement)wait.until((Function)new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return driver.findElement(locator);
            }
        });
        return elt;
    }

    public void waitUntilElementNotPresent(final By locator) {
        FluentWait wait = new FluentWait((Object)driver).withTimeout(30L, TimeUnit.SECONDS).pollingEvery(5L, TimeUnit.SECONDS);
        wait.until((Function)new Function<WebDriver, By>(){

            public By apply(WebDriver driver) {
                try {
                    driver.findElement(locator);
                }
                catch (NoSuchElementException ex) {
                    return locator;
                }
                return null;
            }
        });
    }

    public static WebElement findElementWithTimeout(By by, WebElement parentElement) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, 30000, parentElement);
    }

    public static void waitUntilEnabled(WebElement element, int timeout) throws NotFoundException {
        SystemClock clock = new SystemClock();
        long end = clock.laterBy((long)timeout);
        while (clock.isNowBefore(end)) {
            if (element.isEnabled()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        throw new NotFoundException("Element not enabled after timeout: " + element);
    }

    public static void waitUntilEnabled(WebElement element) throws NotFoundException {
        AbstractTest.waitUntilEnabled(element, 10000);
    }

    public static WebElement findElementAndWaitUntilEnabled(By by, int findElementTimeout, int waitUntilEnabledTimeout) throws NotFoundException {
        WebElement element = AbstractTest.findElementWithTimeout(by, findElementTimeout);
        SystemClock clock = new SystemClock();
        long end = clock.laterBy((long)findElementTimeout);
        StaleElementReferenceException lastException = null;
        while (clock.isNowBefore(end)) {
            try {
                AbstractTest.waitUntilEnabled(element, waitUntilEnabledTimeout);
                return element;
            }
            catch (StaleElementReferenceException sere) {
                element = AbstractTest.findElementWithTimeout(by, findElementTimeout);
                lastException = sere;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        throw new NotFoundException(String.format("Couldn't find element '%s' after timeout", by), (Throwable)lastException);
    }

    public static WebElement findElementAndWaitUntilEnabled(By by) throws NotFoundException {
        return AbstractTest.findElementAndWaitUntilEnabled(by, 30000, 10000);
    }

    public static void findElementWaitUntilEnabledAndClick(By by, int findElementTimeout, int waitUntilEnabledTimeout) throws NotFoundException {
        WebElement element = AbstractTest.findElementAndWaitUntilEnabled(by, findElementTimeout, waitUntilEnabledTimeout);
        SystemClock clock = new SystemClock();
        long end = clock.laterBy((long)findElementTimeout);
        Throwable lastException = null;
        while (clock.isNowBefore(end)) {
            try {
                element.click();
                return;
            }
            catch (ElementNotVisibleException enve) {
                element = AbstractTest.findElementAndWaitUntilEnabled(by, findElementTimeout, waitUntilEnabledTimeout);
                lastException = enve;
            }
            catch (StaleElementReferenceException sere) {
                element = AbstractTest.findElementAndWaitUntilEnabled(by, findElementTimeout, waitUntilEnabledTimeout);
                lastException = sere;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        throw new NotFoundException(String.format("Couldn't find element '%s' after timeout", by), lastException);
    }

    public static void findElementWaitUntilEnabledAndClick(By by) throws NotFoundException {
        AbstractTest.findElementWaitUntilEnabledAndClick(by, 30000, 10000);
    }

    public LoginPage getLoginPage() {
        return AbstractTest.get(NUXEO_URL + "/logout", LoginPage.class);
    }

    public LoginPage logout() {
        return this.getLoginPage();
    }

    public <T extends AbstractPage> T nav(Class<T> pageClass, String linkText) {
        WebElement link = AbstractTest.findElementWithTimeout(By.linkText((String)linkText));
        if (link == null) {
            return null;
        }
        link.click();
        return (T)((AbstractPage)AbstractTest.asPage(pageClass));
    }

    public void navToUrl(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        driver.navigate().to(url);
    }

    public DocumentBasePage login() throws DocumentBasePage.UserNotConnectedException {
        return this.login("Administrator", "Administrator");
    }

    public DocumentBasePage login(String username, String password) throws DocumentBasePage.UserNotConnectedException {
        DocumentBasePage documentBasePage = this.getLoginPage().login(username, password, DocumentBasePage.class);
        documentBasePage.checkUserConnected(username);
        return documentBasePage;
    }

    public LoginPage loginInvalid(String username, String password) {
        LoginPage loginPage = this.getLoginPage().login(username, password, LoginPage.class);
        return loginPage;
    }

    protected DocumentBasePage initRepository(DocumentBasePage currentPage) throws Exception {
        return this.createWorkspace(currentPage, "Test Workspace", "Test Workspace for my dear WebDriver.");
    }

    protected void cleanRepository(DocumentBasePage currentPage) throws Exception {
        this.deleteWorkspace(currentPage, "Test Workspace");
    }

    protected DocumentBasePage createWorkspace(DocumentBasePage currentPage, String workspaceTitle, String workspaceDescription) {
        DocumentBasePage workspacesPage = currentPage.getNavigationSubPage().goToDocument("Workspaces");
        WorkspaceFormPage workspaceCreationFormPage = workspacesPage.getWorkspacesContentTab().getWorkspaceCreatePage();
        DocumentBasePage workspacePage = workspaceCreationFormPage.createNewWorkspace(workspaceTitle, workspaceDescription);
        return workspacePage;
    }

    protected void deleteWorkspace(DocumentBasePage currentPage, String workspaceTitle) {
        DocumentBasePage workspacesPage = currentPage.getNavigationSubPage().goToDocument("Workspaces");
        workspacesPage.getContentTab().removeDocument(workspaceTitle);
    }

    protected FileDocumentBasePage createFile(DocumentBasePage currentPage, String fileTitle, String fileDescription, boolean uploadBlob, String filePrefix, String fileSuffix, String fileContent) throws IOException {
        FileCreationFormPage fileCreationFormPage = currentPage.getContentTab().getDocumentCreatePage("File", FileCreationFormPage.class);
        String fileToUploadPath = null;
        if (uploadBlob) {
            fileToUploadPath = this.getTmpFileToUploadPath(filePrefix, fileSuffix, fileContent);
        }
        FileDocumentBasePage filePage = fileCreationFormPage.createFileDocument(fileTitle, fileDescription, fileToUploadPath);
        return filePage;
    }

    protected String getTmpFileToUploadPath(String filePrefix, String fileSuffix, String fileContent) throws IOException {
        File tmpFile = File.createTempFile(filePrefix, fileSuffix);
        tmpFile.deleteOnExit();
        FileUtils.writeFile((File)tmpFile, (String)fileContent);
        Assert.assertTrue((boolean)tmpFile.exists());
        Assert.assertEquals((Object)"file", (Object)tmpFile.toURI().toURL().getProtocol());
        return tmpFile.getAbsolutePath();
    }

    static {
        proxyServer = null;
    }
}

