/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.util.List;
import org.junit.Assert;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.SystemClock;

public class ContentTabSubPage
extends DocumentBasePage {
    private static final String DELETE_BUTTON_XPATH = "//input[@value=\"Delete\"]";
    @Required
    @FindBy(id="document_content")
    WebElement documentContentForm;
    @FindBy(linkText="New")
    WebElement newButton;
    @FindBy(id="cv_document_content_0_quickFilterForm:nxl_document_content_filter:nxw_search_title")
    WebElement filterInput;
    @FindBy(id="cv_document_content_0_quickFilterForm:submitFilter")
    WebElement filterButton;
    @FindBy(id="cv_document_content_0_resetFilterForm:resetFilter")
    WebElement clearFilterButton;
    @FindBy(xpath="//form[@id=\"document_content\"]//table[@class=\"dataOutput\"]/tbody//tr")
    List<WebElement> childDocumentRows;

    public List<WebElement> getChildDocumentRows() {
        return this.childDocumentRows;
    }

    public ContentTabSubPage(WebDriver driver) {
        super(driver);
    }

    public DocumentBasePage goToDocument(String documentTitle) {
        this.documentContentForm.findElement(By.linkText((String)documentTitle)).click();
        return this.asPage(DocumentBasePage.class);
    }

    public <T> T getDocumentCreatePage(String docType, Class<T> pageClassToProxy) {
        this.newButton.click();
        WebElement link = null;
        for (WebElement element : this.driver.findElements(By.className((String)"documentType"))) {
            try {
                link = element.findElement(By.linkText((String)docType));
                break;
            }
            catch (NoSuchElementException e) {
            }
        }
        Assert.assertNotNull(link);
        link.click();
        return this.asPage(pageClassToProxy);
    }

    public DocumentBasePage removeDocument(String documentTitle) {
        List trelements = this.documentContentForm.findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr"));
        for (WebElement trItem : trelements) {
            try {
                trItem.findElement(By.linkText((String)documentTitle));
                WebElement checkBox = trItem.findElement(By.xpath((String)"td/input[@type=\"checkbox\"]"));
                checkBox.click();
                break;
            }
            catch (NoSuchElementException e) {
            }
        }
        ContentTabSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)DELETE_BUTTON_XPATH));
        Alert alert = this.driver.switchTo().alert();
        Assert.assertEquals((Object)"Delete selected document(s)?", (Object)alert.getText());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        alert.accept();
        return this.asPage(DocumentBasePage.class);
    }

    public void filterDocument(String filter, int expectedNbOfDisplayedResult, int timeout) {
        this.filterInput.clear();
        this.filterInput.sendKeys(new CharSequence[]{filter});
        this.filterButton.click();
        SystemClock clock = new SystemClock();
        long end = clock.laterBy((long)timeout);
        while (clock.isNowBefore(end)) {
            try {
                if (this.getChildDocumentRows().size() == expectedNbOfDisplayedResult) {
                    return;
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
            }
            catch (NoSuchElementException ex) {}
        }
    }

    public void clearFilter(int expectedNbOfDisplayedResult, int timeout) {
        this.clearFilterButton.click();
        SystemClock clock = new SystemClock();
        long end = clock.laterBy((long)timeout);
        while (clock.isNowBefore(end)) {
            try {
                if (this.getChildDocumentRows().size() == expectedNbOfDisplayedResult) {
                    return;
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
            }
            catch (NoSuchElementException ex) {}
        }
    }
}

