/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.wizard;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.functionaltests.pages.wizard.AbstractWizardPage;
import org.nuxeo.functionaltests.pages.wizard.ConnectWizardPage;
import org.nuxeo.functionaltests.pages.wizard.IFrameHelper;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WizardPage
extends AbstractWizardPage {
    protected static final String NEXT_BUTTON_LOCATOR = "id('btnNext')";
    protected static final String PREV_BUTTON_LOCATOR = "id('btnPrev')";

    public WizardPage(WebDriver driver) {
        super(driver);
        IFrameHelper.focusOnWizardPage(driver);
    }

    public WizardPage next() {
        return this.next(WizardPage.class, false);
    }

    public WizardPage next(Boolean waitForURLChange) {
        return this.next(WizardPage.class, waitForURLChange);
    }

    public WizardPage previous() {
        return this.previous(WizardPage.class, false);
    }

    public WizardPage previous(Boolean waitForURLChange) {
        return this.previous(WizardPage.class, waitForURLChange);
    }

    @Override
    protected String getNextButtonLocator() {
        return NEXT_BUTTON_LOCATOR;
    }

    @Override
    protected String getPreviousButtonLocator() {
        return PREV_BUTTON_LOCATOR;
    }

    public ConnectWizardPage getConnectPage() {
        this.driver.switchTo().frame("connectForm");
        return this.asPage(ConnectWizardPage.class);
    }

    public boolean hasError() {
        return this.getErrors().size() > 0;
    }

    public List<String> getErrors() {
        List errorsEl = this.driver.findElements(By.xpath((String)"//div[@class='errBlock']/div[@class='errItem']"));
        ArrayList<String> errors = new ArrayList<String>();
        for (WebElement errorEl : errorsEl) {
            if (errorEl.getText() == null || errorEl.getText().length() <= 0) continue;
            errors.add(errorEl.getText());
        }
        return errors;
    }

    public String getTitle2() {
        WebElement title2 = WizardPage.findElementWithTimeout(By.xpath((String)"//h2"));
        if (title2 == null) {
            return null;
        }
        return title2.getText();
    }
}

