/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.SystemClock;

public class ArchivedVersionsSubPage
extends DocumentBasePage {
    private static final String DELETE_ACTION_ID = "CURRENT_VERSION_SELECTION_DELETE";
    private static final String VIEW_VERSION_ACTION_ID = "VIEW_VERSION";
    private static final String RESTORE_VERSION_ACTION_ID = "RESTORE_VERSION";
    @Required
    @FindBy(id="document_versions")
    WebElement documentVersions;
    @FindBy(id="document_versions_form")
    WebElement documentVersionsForm;

    public ArchivedVersionsSubPage(WebDriver driver) {
        super(driver);
    }

    public List<String> getVersionLabels() {
        List trElements;
        ArrayList<String> versionLabels = new ArrayList<String>();
        try {
            trElements = this.documentVersionsForm.findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr"));
        }
        catch (NoSuchElementException nsee) {
            return versionLabels;
        }
        for (WebElement trItem : trElements) {
            try {
                WebElement versionLabel = trItem.findElement(By.xpath((String)"td[2]"));
                versionLabels.add(versionLabel.getText());
            }
            catch (NoSuchElementException e) {}
        }
        return versionLabels;
    }

    public ArchivedVersionsSubPage selectVersion(String versionLabel) {
        List trElements = this.documentVersionsForm.findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr"));
        for (WebElement trItem : trElements) {
            try {
                trItem.findElement(By.xpath((String)("td[text()=\"" + versionLabel + "\"]")));
                WebElement checkBox = trItem.findElement(By.xpath((String)"td/input[@type=\"checkbox\"]"));
                checkBox.click();
                break;
            }
            catch (NoSuchElementException e) {
            }
        }
        return this.asPage(ArchivedVersionsSubPage.class);
    }

    public void checkCanRemoveSelectedVersions(boolean canRemove) {
        this.checkCanExecuteActionOnSelectedVersions(DELETE_ACTION_ID, canRemove);
    }

    public void checkCanExecuteActionOnSelectedVersions(String actionId, boolean canExecute) {
        block3: {
            try {
                ArchivedVersionsSubPage.findElementAndWaitUntilEnabled(By.xpath((String)("//span[@id=\"" + actionId + "\"]/input")), 30000, 2000);
                if (!canExecute) {
                    Assert.fail((String)(actionId + " action should not be enabled because there is no version selected."));
                }
            }
            catch (NotFoundException nfe) {
                if (!canExecute) break block3;
                nfe.printStackTrace();
                Assert.fail((String)(actionId + " action should be enabled because there is at least one version selected."));
            }
        }
    }

    public ArchivedVersionsSubPage removeSelectedVersions() {
        ArchivedVersionsSubPage archivedVersionsPage = null;
        SystemClock clock = new SystemClock();
        long end = clock.laterBy(30000L);
        while (clock.isNowBefore(end)) {
            try {
                archivedVersionsPage = this.executeActionOnSelectedVersions(DELETE_ACTION_ID, true, ArchivedVersionsSubPage.class, 2000, 10000);
            }
            catch (NotFoundException nfe) {
                if (archivedVersionsPage == null) break;
                return archivedVersionsPage;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        throw new WebDriverException("Couldn't remove selected versions");
    }

    public <T> T executeActionOnSelectedVersions(String actionId, boolean isConfirm, Class<T> pageClass, int findElementTimeout, int waitUntilEnabledTimeout) {
        ArchivedVersionsSubPage.findElementWaitUntilEnabledAndClick(By.xpath((String)("//span[@id=\"" + actionId + "\"]/input")), findElementTimeout, waitUntilEnabledTimeout);
        if (isConfirm) {
            Alert alert = this.driver.switchTo().alert();
            Assert.assertEquals((Object)"Delete selected document(s)?", (Object)alert.getText());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            alert.accept();
        }
        return this.asPage(pageClass);
    }

    public DocumentBasePage viewVersion(String versionLabel) {
        return this.executeActionOnVersion(versionLabel, VIEW_VERSION_ACTION_ID);
    }

    public DocumentBasePage restoreVersion(String versionLabel) {
        return this.executeActionOnVersion(versionLabel, RESTORE_VERSION_ACTION_ID);
    }

    public DocumentBasePage executeActionOnVersion(String versionLabel, String actionId) {
        List trElements = this.documentVersionsForm.findElement(By.tagName((String)"tbody")).findElements(By.tagName((String)"tr"));
        for (WebElement trItem : trElements) {
            try {
                trItem.findElement(By.xpath((String)("td[text()=\"" + versionLabel + "\"]")));
                WebElement actionButton = trItem.findElement(By.xpath((String)("td/div/span[@id=\"" + actionId + "\"]/input")));
                actionButton.click();
                break;
            }
            catch (NoSuchElementException e) {
            }
        }
        return this.asPage(DocumentBasePage.class);
    }
}

