/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriverException;

public class ScreenShotFileOutput
implements OutputType<File> {
    private static final Log log = LogFactory.getLog(ScreenShotFileOutput.class);
    protected String screenshotFilePrefix;

    public ScreenShotFileOutput(String screenshotFilePrefix) {
        this.screenshotFilePrefix = screenshotFilePrefix;
    }

    public File convertFromBase64Png(String base64Png) {
        byte[] data = (byte[])BYTES.convertFromBase64Png(base64Png);
        return this.convertFromPngBytes(data);
    }

    public File convertFromPngBytes(byte[] data) {
        File file;
        FileOutputStream fos = null;
        try {
            String location = System.getProperty("basedir") + File.separator + "target";
            File outputFolder = new File(location);
            if (!outputFolder.exists() || !outputFolder.isDirectory()) {
                outputFolder = null;
            }
            File tmpFile = File.createTempFile(this.screenshotFilePrefix, ".png", outputFolder);
            log.trace((Object)String.format("Created screenshot file named '%s'", tmpFile.getPath()));
            fos = new FileOutputStream(tmpFile);
            fos.write(data);
            file = tmpFile;
        }
        catch (IOException e) {
            try {
                throw new WebDriverException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return file;
    }
}

