/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.functionaltests.forms.AbstractWidgetElement;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class FileWidgetElement
extends AbstractWidgetElement {
    public FileWidgetElement(WebDriver driver, String id) {
        super(driver, id);
    }

    public String getFilename(boolean isEdit) {
        WebElement link = isEdit ? this.getSubElement("default_download:download") : this.getSubElement("download");
        return link.getText();
    }

    public void uploadTestFile(String prefix, String suffix, String content) throws IOException {
        String fileToUploadPath = this.getTmpFileToUploadPath(prefix, suffix, content);
        WebElement upRadioButton = this.getSubElement("choiceupload");
        upRadioButton.click();
        WebElement fileInput = this.getSubElement("upload");
        fileInput.sendKeys(new CharSequence[]{fileToUploadPath});
    }

    public void removeFile() {
        if (this.hasSubElement("choicenone")) {
            WebElement delRadioButton = this.getSubElement("choicenone");
            delRadioButton.click();
        } else if (this.hasSubElement("choicedelete")) {
            WebElement delRadioButton = this.getSubElement("choicedelete");
            delRadioButton.click();
        } else {
            throw new NoSuchElementException("No delete choice available on widget");
        }
    }

    protected String getTmpFileToUploadPath(String filePrefix, String fileSuffix, String fileContent) throws IOException {
        File tmpFile = File.createTempFile(filePrefix, fileSuffix);
        tmpFile.deleteOnExit();
        FileUtils.writeFile((File)tmpFile, (String)fileContent);
        Assert.assertTrue((boolean)tmpFile.exists());
        Assert.assertEquals((Object)"file", (Object)tmpFile.toURI().toURL().getProtocol());
        return tmpFile.getAbsolutePath();
    }
}

