/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.forms.WidgetElement;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class LayoutElement
extends AbstractPage {
    protected String id;

    public LayoutElement(WebDriver driver, String id) {
        super(driver);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSubElementId(String id) {
        String finalId = id;
        if (this.id != null) {
            finalId = this.id + ":" + id;
        }
        return finalId;
    }

    protected <T> T instantiateWidget(String id, Class<T> pageClassToProxy) {
        try {
            try {
                Constructor<T> constructor = pageClassToProxy.getConstructor(WebDriver.class, String.class);
                return constructor.newInstance(this.driver, this.getSubElementId(id));
            }
            catch (NoSuchMethodException e) {
                return pageClassToProxy.newInstance();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public WidgetElement getWidget(String id) {
        return this.getWidget(id, WidgetElement.class);
    }

    public <T> T getWidget(String id, Class<T> widgetClassToProxy) {
        T res = this.instantiateWidget(id, widgetClassToProxy);
        res = AbstractTest.fillElement(widgetClassToProxy, res);
        return res;
    }

    protected boolean hasSubElement(String id) {
        return this.hasElement(By.id((String)this.getSubElementId(id)));
    }

    public WebElement getElement(String id) {
        return this.driver.findElement(By.id((String)id));
    }

    public WebElement getElement(String id, boolean wait) {
        return AbstractTest.findElementWithTimeout(By.id((String)id));
    }

    public WebElement getSubElement(String id) {
        return this.getElement(this.getSubElementId(id));
    }

    public WebElement getSubElement(String id, boolean wait) {
        return this.getElement(this.getSubElementId(id), wait);
    }

    public void setInput(WebElement elt, String value) {
        elt.click();
        elt.clear();
        if (value != null) {
            elt.sendKeys(new CharSequence[]{value});
        }
    }

    public void setInput(String id, String value) {
        WebElement elt = this.getSubElement(id);
        this.setInput(elt, value);
    }

    public void setInput(Map<String, String> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            this.setInput(entry.getKey(), entry.getValue());
        }
    }
}

