/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import com.google.common.base.Function;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

public class Select2WidgetElement {
    private static final Log log = LogFactory.getLog(Select2WidgetElement.class);
    private static final String S2_SINGLE_INPUT_XPATH = "//*[@id='select2-drop']/div/input";
    private static final String S2_MULTIPLE_INPUT_XPATH = "ul/li/input";
    private static final String S2_SUGGEST_RESULT_XPATH = "//*[@id='select2-drop']//li[contains(@class,'select2-result-selectable')]/div";
    private static final String S2_CSS_ACTIVE_CLASS = "select2-active";
    private static final int SELECT2_LOADING_TIMEOUT = 20;
    private Function<WebDriver, Boolean> s2SingleWaitFunction;
    private Function<WebDriver, Boolean> s2MultipleWaitFunction;
    private final WebElement element;
    private final WebDriver driver;
    private boolean mutliple = false;

    public Select2WidgetElement(WebDriver driver, By by) {
        this.driver = driver;
        this.element = driver.findElement(by);
        this.s2SingleWaitFunction = new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                WebElement searchInput = driver.findElement(By.xpath((String)Select2WidgetElement.S2_SINGLE_INPUT_XPATH));
                return !searchInput.getAttribute("class").contains(Select2WidgetElement.S2_CSS_ACTIVE_CLASS);
            }
        };
        this.s2MultipleWaitFunction = new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                WebElement searchInput = Select2WidgetElement.this.element.findElement(By.xpath((String)Select2WidgetElement.S2_MULTIPLE_INPUT_XPATH));
                return !searchInput.getAttribute("class").contains(Select2WidgetElement.S2_CSS_ACTIVE_CLASS);
            }
        };
    }

    public Select2WidgetElement(WebDriver driver, By by, boolean multiple) {
        this(driver, by);
        this.mutliple = multiple;
    }

    public void selectValue(String value) {
        WebElement select2Field = null;
        select2Field = this.mutliple ? this.element : this.element.findElement(By.xpath((String)"a[contains(@class,'select2-choice select2-default')]"));
        select2Field.click();
        FluentWait wait = new FluentWait((Object)this.driver).withTimeout(20L, TimeUnit.SECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class);
        WebElement suggestInput = null;
        suggestInput = this.mutliple ? this.driver.findElement(By.xpath((String)"//ul/li[@class='select2-search-field']/input")) : this.driver.findElement(By.xpath((String)S2_SINGLE_INPUT_XPATH));
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            suggestInput.sendKeys(new CharSequence[]{c + ""});
            try {
                wait.until(this.mutliple ? this.s2MultipleWaitFunction : this.s2SingleWaitFunction);
                continue;
            }
            catch (TimeoutException e) {
                if (i == value.length() - 1) {
                    log.error((Object)("Suggestion definitly timed out with last letter : " + c + ". There is something wrong with select2"));
                    throw e;
                }
                log.warn((Object)("Suggestion timed out with letter : " + c + ". Let's try with next letter."));
            }
        }
        WebElement suggestion = this.driver.findElement(By.xpath((String)S2_SUGGEST_RESULT_XPATH));
        suggestion.click();
    }

    public void selectValues(String[] values) {
        for (String value : values) {
            this.selectValue(value);
        }
    }
}

