/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import com.google.common.base.Function;
import java.util.List;
import org.junit.Assert;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.fragment.WebFragment;
import org.nuxeo.functionaltests.pages.HeaderLinksSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class AbstractPage {
    public static int URLCHANGE_MAX_WAIT = 10;
    @FindBy(xpath="//div[@id='nxw_doc_userMenuActions_panel']/ul/li/span")
    public WebElement userServicesForm;
    protected WebDriver driver;

    public AbstractPage(WebDriver driver) {
        this.driver = driver;
    }

    public boolean hasElement(By by) {
        boolean present;
        try {
            this.driver.findElement(by);
            present = true;
        }
        catch (NoSuchElementException e) {
            present = false;
        }
        return present;
    }

    public <T> T get(String url, Class<T> pageClassToProxy) {
        return AbstractTest.get(url, pageClassToProxy);
    }

    public <T> T asPage(Class<T> pageClassToProxy) {
        return AbstractTest.asPage(pageClassToProxy);
    }

    public <T extends WebFragment> T getWebFragment(By by, Class<T> webFragmentClass) {
        return AbstractTest.getWebFragment(by, webFragmentClass);
    }

    public <T extends WebFragment> T getWebFragment(WebElement element, Class<T> webFragmentClass) {
        return AbstractTest.getWebFragment(element, webFragmentClass);
    }

    @Deprecated
    public String getFeedbackMessage() {
        String ret;
        try {
            ret = AbstractPage.findElementWithTimeout(By.xpath((String)"//li[@class=\"errorFeedback\"]")).getText();
        }
        catch (NoSuchElementException e) {
            ret = "";
        }
        return ret.trim();
    }

    public String getErrorFeedbackMessage() {
        String ret = "";
        try {
            List<WebElement> elements = AbstractPage.findElementsWithTimeout(By.xpath((String)"//div[contains(@class, 'errorFeedback')]/div[@class='ambiance-title']"));
            if (elements.size() == 1) {
                ret = elements.get(0).getText();
            } else if (elements.size() > 1) {
                ret = elements.get(1).getText();
            }
        }
        catch (NoSuchElementException e) {
            ret = "";
        }
        return ret.trim();
    }

    public HeaderLinksSubPage getHeaderLinks() {
        Assert.assertNotNull((Object)this.userServicesForm);
        return this.asPage(HeaderLinksSubPage.class);
    }

    public WebElement getFancyBoxContent() {
        WebElement fancyBox = AbstractPage.findElementWithTimeout(By.id((String)"fancybox-content"));
        WebDriverWait wait = new WebDriverWait(this.driver, 30L);
        wait.until((Function)ExpectedConditions.visibilityOf((WebElement)fancyBox));
        return fancyBox;
    }

    public WebElement findElementWithTimeout(By by, int timeout) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, timeout);
    }

    public WebElement findElementWithTimeout(By by, int timeout, WebElement parentElement) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, timeout, parentElement);
    }

    public static WebElement findElementWithTimeout(By by) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by);
    }

    public static List<WebElement> findElementsWithTimeout(By by) throws NoSuchElementException {
        return AbstractTest.findElementsWithTimeout(by);
    }

    public static WebElement findElementWithTimeout(By by, WebElement parentElement) throws NoSuchElementException {
        return AbstractTest.findElementWithTimeout(by, parentElement);
    }

    public static void waitUntilEnabled(WebElement element, int timeout) throws NotFoundException {
        AbstractTest.waitUntilEnabled(element, timeout);
    }

    public static void waitUntilEnabled(WebElement element) throws NotFoundException {
        AbstractTest.waitUntilEnabled(element);
    }

    public static WebElement findElementAndWaitUntilEnabled(By by, int findElementTimeout, int waitUntilEnabledTimeout) throws NotFoundException {
        return AbstractTest.findElementAndWaitUntilEnabled(by, findElementTimeout, waitUntilEnabledTimeout);
    }

    public static WebElement findElementAndWaitUntilEnabled(By by) throws NotFoundException {
        return AbstractTest.findElementAndWaitUntilEnabled(by);
    }

    public static void findElementWaitUntilEnabledAndClick(By by, int findElementTimeout, int waitUntilEnabledTimeout) throws NotFoundException {
        AbstractTest.findElementWaitUntilEnabledAndClick(by, findElementTimeout, waitUntilEnabledTimeout);
    }

    public static void findElementWaitUntilEnabledAndClick(By by) throws NotFoundException {
        AbstractTest.findElementWaitUntilEnabledAndClick(by);
    }

    public void waitUntilURLDifferentFrom(String url) {
        final String refurl = url;
        ExpectedCondition<Boolean> urlchanged = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                return !d.getCurrentUrl().equals(refurl);
            }
        };
        WebDriverWait wait = new WebDriverWait(this.driver, (long)URLCHANGE_MAX_WAIT);
        wait.until((Function)urlchanged);
        if (this.driver.getCurrentUrl().equals(refurl)) {
            System.out.println("Page change failed");
        }
    }

    public void selectItemInDropDownMenu(WebElement selector, String optionLabel) {
        Select select = new Select(selector);
        select.selectByVisibleText(optionLabel);
    }

    public WebDriver switchToFrame(String id) {
        this.driver.switchTo().defaultContent();
        return this.driver.switchTo().frame(id);
    }
}

