/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

public class LoginPage
extends AbstractPage {
    private static final Log log = LogFactory.getLog(LoginPage.class);
    public static final String FEEDBACK_MESSAGE_DIV_XPATH = "//div[contains(@class,'feedbackMessage')]";
    public static final String LOGIN_DIV_XPATH = "//div[@class='login']";
    @Required
    @FindBy(id="username")
    WebElement usernameInputTextBox;
    @Required
    @FindBy(id="password")
    WebElement passwordInputTextBox;
    @Required
    @FindBy(name="Submit")
    WebElement submitButton;
    @Deprecated
    @FindBy(id="language")
    WebElement languageSelectBox;

    public LoginPage(WebDriver driver) {
        super(driver);
    }

    public void login(String username, String password, String language) {
        JavascriptExecutor jsExecutor = (JavascriptExecutor)this.driver;
        this.usernameInputTextBox.sendKeys(new CharSequence[]{username});
        this.passwordInputTextBox.sendKeys(new CharSequence[]{password});
        jsExecutor.executeScript("document.getElementById('username').blur();return true;", new Object[0]);
        jsExecutor.executeScript("document.getElementById('password').blur();return true;", new Object[0]);
        if (language != null) {
            Select languageSelect = new Select(this.languageSelectBox);
            List list = languageSelect.getOptions();
            for (WebElement webElement : list) {
                if (!language.trim().equals(webElement.getText().trim())) continue;
                languageSelect.selectByVisibleText(webElement.getText());
                break;
            }
        }
        this.submitButton.click();
    }

    public void login(String username, String password) {
        this.login(username, password, (String)null);
    }

    public <T> T login(String username, String password, Class<T> pageClassToProxy) {
        try {
            this.login(username, password);
            return this.asPage(pageClassToProxy);
        }
        catch (NoSuchElementException exc) {
            try {
                if (this.hasElement(By.xpath((String)LOGIN_DIV_XPATH))) {
                    this.login(username, password);
                    return this.asPage(pageClassToProxy);
                }
                throw exc;
            }
            catch (NoSuchElementException e) {
                if (this.hasElement(By.xpath((String)LOGIN_DIV_XPATH))) {
                    if (this.hasElement(By.xpath((String)FEEDBACK_MESSAGE_DIV_XPATH))) {
                        throw new NoSuchElementException("Login failed. Application said : " + this.driver.findElement(By.xpath((String)FEEDBACK_MESSAGE_DIV_XPATH)).getText(), (Throwable)e);
                    }
                    throw new NoSuchElementException("Login failed", (Throwable)e);
                }
                throw e;
            }
        }
    }
}

