/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.tabs.SummaryTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class WorkflowHomePage
extends AbstractPage {
    @Required
    @FindBy(xpath="//div[contains(@id, 'cv_user_open_tasks_nxw_current_user_open_tasks_resultsPanel')]")
    protected WebElement userTasksPanel;
    @Required
    @FindBy(linkText="Workflow")
    public WebElement workflowLink;

    public WorkflowHomePage(WebDriver driver) {
        super(driver);
    }

    public boolean taskExistsOnTasksDashboard(String taskName) {
        WebElement taskNameEl = this.userTasksPanel.findElement(By.xpath((String)"//span[contains(@id, 'nxw_routing_task_name')]"));
        return taskName.equals(taskNameEl.getText());
    }

    public void processFirstTask() {
        this.userTasksPanel.findElement(By.xpath((String)"//input[@type='submit' and @value='Process']")).click();
    }

    public SummaryTabSubPage redirectToTask(String taskTitle) {
        this.driver.findElement(By.linkText((String)taskTitle)).click();
        return new SummaryTabSubPage(this.driver);
    }

    public boolean isTasksDashboardEmpty() {
        return !this.userTasksPanel.getText().contains("Task Name");
    }
}

