/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.tabs.SummaryTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class WorkflowTabSubPage
extends DocumentBasePage {
    @FindBy(xpath="//form[contains(@id, 'nxl_current_route_layout_current_route_user_tasks_form')]")
    public WebElement workflowTasksForm;
    @FindBy(xpath="//select[contains(@id, 'nxw_validationOrReview')]")
    public WebElement reviewSelector;

    public WorkflowTabSubPage(WebDriver driver) {
        super(driver);
    }

    public void addWorkflowReviewer() {
        Select2WidgetElement particpants = new Select2WidgetElement(this.driver, By.xpath((String)"//div[contains(@id, 'nxw_participants_select2')]"), true);
        particpants.selectValue("jdoe");
        this.selectItemInDropDownMenu(this.reviewSelector, "Simple review");
    }

    public void showGraphView() {
        WorkflowTabSubPage.findElementAndWaitUntilEnabled(By.linkText((String)"Show graph view")).click();
    }

    public void closeGraphView() {
        WorkflowTabSubPage.findElementAndWaitUntilEnabled(By.id((String)"fancybox-close")).click();
    }

    public void startWorkflow() {
        WorkflowTabSubPage.findElementAndWaitUntilEnabled(By.xpath((String)"//input[@value='Start the review']")).click();
    }

    public void endTask(String taskName) {
        WorkflowTabSubPage.findElementAndWaitUntilEnabled(By.xpath((String)String.format("//input[@value='%s']", taskName))).click();
    }

    public WebElement getTaskLayoutNode() {
        return WorkflowTabSubPage.findElementWithTimeout(By.xpath((String)"//div[starts-with(@id, 'task_')]"));
    }

    @Override
    public SummaryTabSubPage getSummaryTab() {
        this.clickOnLinkIfNotSelected(this.summaryTabLink);
        return this.asPage(SummaryTabSubPage.class);
    }
}

