/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.rules.TestWatchman;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.functionaltests.AbstractTest;
import org.nuxeo.functionaltests.ScreenshotTaker;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class LogTestWatchman
extends TestWatchman {
    protected static final Log log = LogFactory.getLog(AbstractTest.class);
    protected String lastScreenshot;
    protected String lastPageSource;
    protected String filePrefix;
    protected RemoteWebDriver driver;
    protected String serverURL;

    public LogTestWatchman(RemoteWebDriver driver, String serverURL) {
        this.driver = driver;
        this.serverURL = serverURL;
    }

    public LogTestWatchman() {
    }

    public Statement apply(final Statement base, final FrameworkMethod method, Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LogTestWatchman.this.starting(method);
                try {
                    if (base instanceof RunAfters) {
                        Field fAtersField = RunAfters.class.getDeclaredField("fAfters");
                        fAtersField.setAccessible(true);
                        List afters = (List)fAtersField.get(base);
                        if (afters != null && !afters.isEmpty()) {
                            try {
                                FrameworkMethod first = (FrameworkMethod)afters.get(0);
                                Method m = AbstractTest.class.getMethod("runBeforeAfters", null);
                                FrameworkMethod f = new FrameworkMethod(m);
                                if (first != null && !first.equals((Object)f)) {
                                    afters.add(0, f);
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                    }
                    base.evaluate();
                    LogTestWatchman.this.succeeded(method);
                }
                catch (Throwable t) {
                    LogTestWatchman.this.failed(t, method);
                    throw t;
                }
                finally {
                    LogTestWatchman.this.finished(method);
                }
            }
        };
    }

    @Deprecated
    public File dumpPageSource(String filename) {
        ScreenshotTaker taker = new ScreenshotTaker();
        return taker.dumpPageSource((WebDriver)this.driver, filename);
    }

    public void failed(Throwable e, FrameworkMethod method) {
        String className = this.getTestClassName(method);
        String methodName = method.getName();
        log.error((Object)String.format("Test '%s#%s' failed", className, methodName), e);
        if (this.lastScreenshot == null || this.lastPageSource == null) {
            File temp;
            ScreenshotTaker taker = new ScreenshotTaker();
            if (this.lastScreenshot == null) {
                temp = taker.takeScreenshot((WebDriver)this.driver, this.filePrefix);
                String string = this.lastScreenshot = temp != null ? temp.getAbsolutePath() : null;
            }
            if (this.lastPageSource == null) {
                temp = taker.dumpPageSource((WebDriver)this.driver, this.filePrefix);
                this.lastPageSource = temp != null ? temp.getAbsolutePath() : null;
            }
        }
        log.info((Object)String.format("Created screenshot file named '%s'", this.lastScreenshot));
        log.info((Object)String.format("Created page source file named '%s'", this.lastPageSource));
        super.failed(e, method);
    }

    public void finished(FrameworkMethod method) {
        log.info((Object)String.format("Finished test '%s#%s'", this.getTestClassName(method), method.getName()));
        this.lastScreenshot = null;
        this.lastPageSource = null;
        super.finished(method);
    }

    public RemoteWebDriver getDriver() {
        return this.driver;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    protected String getTestClassName(FrameworkMethod method) {
        return method.getMethod().getDeclaringClass().getName();
    }

    protected void logOnServer(String message) {
        if (this.driver != null) {
            this.driver.get(String.format("%s/restAPI/systemLog?token=dolog&level=WARN&message=----- WebDriver: %s", this.serverURL, URIUtils.quoteURIPathComponent((String)message, (boolean)true)));
        } else {
            log.warn((Object)String.format("Cannot log on server message: %s", message));
        }
    }

    public void runBeforeAfters() {
        ScreenshotTaker taker = new ScreenshotTaker();
        this.lastScreenshot = taker.takeScreenshot((WebDriver)this.driver, this.filePrefix).getAbsolutePath();
        this.lastPageSource = taker.dumpPageSource((WebDriver)this.driver, this.filePrefix).getAbsolutePath();
    }

    public void setDriver(RemoteWebDriver driver) {
        this.driver = driver;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void starting(FrameworkMethod method) {
        String message = String.format("Starting test '%s#%s'", this.getTestClassName(method), method.getName());
        log.info((Object)message);
        String className = this.getTestClassName(method);
        String methodName = method.getName();
        this.filePrefix = String.format("screenshot-lastpage-%s-%s", className, methodName);
        this.logOnServer(message);
    }

    public void succeeded(FrameworkMethod method) {
        if (this.lastPageSource != null) {
            new File(this.lastPageSource).delete();
        }
        if (this.lastScreenshot != null) {
            new File(this.lastScreenshot).delete();
        }
    }

    @Deprecated
    public File takeScreenshot(String filename) {
        ScreenshotTaker taker = new ScreenshotTaker();
        return taker.takeScreenshot((WebDriver)this.driver, filename);
    }
}

