/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import org.nuxeo.functionaltests.forms.AbstractWidgetElement;
import org.nuxeo.functionaltests.forms.WidgetElement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ListWidgetElement
extends AbstractWidgetElement {
    public ListWidgetElement(WebDriver driver, String id) {
        super(driver, id);
    }

    protected String getListElementId() {
        return String.format("%s_input", this.getWidgetId());
    }

    protected String getListSubElementId(String subId, int index) {
        return String.format("%s:%s:%s", this.getListElementId(), index, subId);
    }

    public void addNewElement() {
        String wid = this.getWidgetId();
        WebElement addElement = this.getSubElement(wid + "_add");
        addElement.click();
    }

    public void removeElement(int index) {
        String wid = this.getWidgetId();
        String delId = String.format("%s:%s:%s_delete", this.getListElementId(), index, wid);
        WebElement delElement = this.getSubElement(delId);
        delElement.click();
    }

    public void waitForSubWidget(String id, int index) {
        this.getSubElement(this.getListSubElementId(id, index), true);
    }

    public WidgetElement getSubWidget(String id, int index, boolean wait) {
        if (wait) {
            this.waitForSubWidget(id, index);
        }
        return this.getWidget(this.getListSubElementId(id, index));
    }

    public <T> T getSubWidget(String id, int index, Class<T> widgetClassToProxy, boolean wait) {
        if (wait) {
            this.waitForSubWidget(id, index);
        }
        return this.getWidget(this.getListSubElementId(id, index), widgetClassToProxy);
    }
}

