/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import com.google.common.base.Function;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

public class Select2WidgetElement
extends WebFragmentImpl {
    private static final Log log = LogFactory.getLog(Select2WidgetElement.class);
    private static final String S2_CSS_ACTIVE_CLASS = "select2-active";
    private static final String S2_MULTIPLE_CURRENT_SELECTION_XPATH = "ul[@class='select2-choices']/li[@class='select2-search-choice']";
    private static final String S2_MULTIPLE_INPUT_XPATH = "ul/li/input";
    private static final String S2_SINGLE_CURRENT_SELECTION_XPATH = "a[@class='select2-choice']/span[@class='select2-chosen']";
    private static final String S2_SINGLE_INPUT_XPATH = "//*[@id='select2-drop']/div/input";
    private static final String S2_SUGGEST_RESULT_XPATH = "//*[@id='select2-drop']//li[contains(@class,'select2-result-selectable')]/div";
    private static final int SELECT2_LOADING_TIMEOUT = 20;
    private boolean mutliple = false;

    public Select2WidgetElement(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    public Select2WidgetElement(WebDriver driver, WebElement element, boolean multiple) {
        this(driver, element);
        this.mutliple = multiple;
    }

    public WebElement getSelectedValue() {
        if (this.mutliple) {
            throw new UnsupportedOperationException("The select2 is multiple and has multiple selected values");
        }
        return this.element.findElement(By.xpath((String)S2_SINGLE_CURRENT_SELECTION_XPATH));
    }

    public List<WebElement> getSelectedValues() {
        if (!this.mutliple) {
            throw new UnsupportedOperationException("The select2 is not multiple and can't have multiple selected values");
        }
        return this.element.findElements(By.xpath((String)S2_MULTIPLE_CURRENT_SELECTION_XPATH));
    }

    protected String getSubmittedValue() {
        String eltId = this.element.getAttribute("id");
        String submittedEltId = this.element.getAttribute("id").substring("s2id_".length(), eltId.length());
        return this.driver.findElement(By.id((String)submittedEltId)).getAttribute("value");
    }

    protected List<WebElement> getSuggestedEntries() {
        try {
            return this.driver.findElements(By.xpath((String)S2_SUGGEST_RESULT_XPATH));
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void removeFromSelection(String displayedText) {
        if (!this.mutliple) {
            throw new UnsupportedOperationException("The select2 is not multiple and you can't remove a specific value");
        }
        final String submittedValueBefore = this.getSubmittedValue();
        for (WebElement el : this.getSelectedValues()) {
            if (!el.getText().endsWith("/" + displayedText)) continue;
            el.findElement(By.xpath((String)"a[@class='select2-search-choice-close']")).click();
        }
        Locator.waitUntilGivenFunction(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !submittedValueBefore.equals(Select2WidgetElement.this.getSubmittedValue());
            }
        });
    }

    public void selectValue(String value) {
        WebElement select2Field = null;
        select2Field = this.mutliple ? this.element : this.element.findElement(By.xpath((String)"a[contains(@class,'select2-choice select2-default')]"));
        select2Field.click();
        FluentWait wait = new FluentWait((Object)(!this.mutliple ? this.driver.findElement(By.xpath((String)S2_SINGLE_INPUT_XPATH)) : this.element.findElement(By.xpath((String)S2_MULTIPLE_INPUT_XPATH)))).withTimeout(20L, TimeUnit.SECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class);
        WebElement suggestInput = null;
        suggestInput = this.mutliple ? this.driver.findElement(By.xpath((String)"//ul/li[@class='select2-search-field']/input")) : this.driver.findElement(By.xpath((String)S2_SINGLE_INPUT_XPATH));
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            suggestInput.sendKeys(new CharSequence[]{c + ""});
            try {
                Select2Wait s2WaitFunction = new Select2Wait();
                wait.until((Function)s2WaitFunction);
                continue;
            }
            catch (TimeoutException e) {
                if (i == value.length() - 1) {
                    log.error((Object)("Suggestion definitly timed out with last letter : " + c + ". There is something wrong with select2"));
                    throw e;
                }
                log.warn((Object)("Suggestion timed out with letter : " + c + ". Let's try with next letter."));
            }
        }
        if (this.getSuggestedEntries() != null && this.getSuggestedEntries().size() > 1) {
            log.warn((Object)("Suggestion for element " + this.element.getAttribute("id") + " returned more than 1 result, the first suggestion will be selected : " + this.getSuggestedEntries().get(0).getText()));
        }
        WebElement suggestion = this.driver.findElement(By.xpath((String)S2_SUGGEST_RESULT_XPATH));
        suggestion.click();
    }

    public void selectValues(String[] values) {
        for (String value : values) {
            this.selectValue(value);
        }
    }

    private static class Select2Wait
    implements Function<WebElement, Boolean> {
        private Select2Wait() {
        }

        public Boolean apply(WebElement element) {
            boolean result = !element.getAttribute("class").contains(Select2WidgetElement.S2_CSS_ACTIVE_CLASS);
            return result;
        }
    }
}

