/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import com.google.common.base.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.tabs.SummaryTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WorkflowHomePage
extends AbstractPage {
    protected static final Log log = LogFactory.getLog(WorkflowHomePage.class);
    @Required
    @FindBy(xpath="//div[contains(@id, 'cv_user_open_tasks_nxw_current_user_open_tasks_resultsPanel')]")
    protected WebElement userTasksPanel;
    @Required
    @FindBy(id="nxl_userOpenTasksLayout:contentViewLayoutSelectForm_cv_user_open_tasks_nxw_current_user_open_tasks:refreshContentViewLink")
    protected WebElement refreshTask;
    @Required
    @FindBy(linkText="Workflow")
    public WebElement workflowLink;

    public WorkflowHomePage(WebDriver driver) {
        super(driver);
    }

    public boolean taskExistsOnTasksDashboard(String taskName) {
        WebElement taskNameEl = Locator.findElementWithTimeout(By.xpath((String)"//span[contains(@id, 'nxw_routing_task_name')]"), this.userTasksPanel);
        return taskName.equals(taskNameEl.getText());
    }

    public void processFirstTask() {
        this.userTasksPanel.findElement(By.xpath((String)"//input[@type='submit' and @value='Process']")).click();
    }

    public SummaryTabSubPage redirectToTask(String taskTitle) {
        this.driver.findElement(By.linkText((String)taskTitle)).click();
        return new SummaryTabSubPage(this.driver);
    }

    public boolean isTasksDashboardEmpty() {
        return !this.userTasksPanel.getText().contains("Task Name");
    }

    public void reassignTask(String taskDirective, String user) {
        TaskFancyBoxFragment taskBox = this.showTaskFancyBox("Reassign task");
        taskBox.waitForTextToBePresent(taskDirective);
        Select2WidgetElement particpants = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)"//div[contains(@id, 'nxl_workflowTaskReassignmentLayout:nxw_task_reassignment_actors_select2')]")), true);
        particpants.selectValue(user);
        taskBox.submit();
    }

    public void delegateTask(String taskDirective, String user) {
        TaskFancyBoxFragment taskBox = this.showTaskFancyBox("Delegate task");
        taskBox.waitForTextToBePresent(taskDirective);
        Select2WidgetElement particpants = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)"//div[contains(@id, 'nxl_workflowTaskReassignmentLayout:nxw_task_reassignment_actors_select2')]")), true);
        particpants.selectValue(user);
        taskBox.submit();
    }

    public TaskFancyBoxFragment showTaskFancyBox(String taskAction) {
        this.driver.findElement(By.xpath((String)String.format("//input[@type='button' and @value='%s']", taskAction))).click();
        WebElement element = this.getFancyBoxContent();
        return this.getWebFragment(element, TaskFancyBoxFragment.class);
    }

    public static class TaskFancyBoxFragment
    extends WebFragmentImpl {
        @FindBy(xpath="//div[@id='fancybox-content']//input[@value='Cancel']")
        public WebElement cancelButton;
        @FindBy(xpath="//div[@id='fancybox-content']//input[@type='submit']")
        public WebElement sumbitButton;

        public TaskFancyBoxFragment(WebDriver driver, WebElement element) {
            super(driver, element);
        }

        public void cancel() {
            this.cancelButton.click();
            WebDriverWait wait = new WebDriverWait(this.driver, 30L);
            wait.until((Function)ExpectedConditions.invisibilityOfElementLocated((By)By.id((String)"fancybox-content")));
        }

        @Override
        public void submit() {
            this.sumbitButton.click();
            WebDriverWait wait = new WebDriverWait(this.driver, 30L);
            wait.until((Function)ExpectedConditions.invisibilityOfElementLocated((By)By.id((String)"fancybox-content")));
        }
    }
}

