/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.NewVocabularyEntryForm;
import org.nuxeo.functionaltests.pages.admincenter.AdminCenterBasePage;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

public class VocabulariesPage
extends AdminCenterBasePage {
    @FindBy(linkText="Add a new vocabulary entry")
    @Required
    WebElement addNewEntryLink;
    @FindBy(id="selectDirectoryForm:directoriesList")
    @Required
    WebElement directoriesListSelectElement;
    @FindBy(id="viewDirectoryEntries")
    @Required
    WebElement directoryEntriesForm;

    public VocabulariesPage(WebDriver driver) {
        super(driver);
    }

    public VocabulariesPage addEntry(String entryId, String parentId, String entryEnglishLabel, String entryFrenchLabel, boolean obsolete, int order) {
        this.addNewEntryLink.click();
        NewVocabularyEntryForm newVocabularyEntryForm = this.getWebFragment(By.id((String)"addEntryView:addEntryForm"), NewVocabularyEntryForm.class);
        newVocabularyEntryForm.setNewVocabularyId(entryId);
        newVocabularyEntryForm.setNewVocabularyEnglishLabel(entryEnglishLabel);
        newVocabularyEntryForm.setNewVocabularyFrenchLabel(entryFrenchLabel);
        newVocabularyEntryForm.setNewVocabularyObsolete(obsolete);
        newVocabularyEntryForm.setNewVocabularyOrder(order);
        newVocabularyEntryForm.setNewVocabularyParentId(parentId);
        newVocabularyEntryForm.save();
        this.waitForLoading();
        return this.asPage(VocabulariesPage.class);
    }

    public VocabulariesPage deleteEntry(String entryId) {
        WebElement entryToBeDeleted = this.getDirectoryEntryRow(entryId);
        WebElement entryDeleteButton = entryToBeDeleted.findElement(By.xpath((String)"td/input[@value='Delete']"));
        entryDeleteButton.click();
        Alert confirmRemove = this.driver.switchTo().alert();
        confirmRemove.accept();
        this.waitForLoading();
        return this.asPage(VocabulariesPage.class);
    }

    public List<String> getDirectoriesList() {
        Select directoriesListSelect = new Select(this.directoriesListSelectElement);
        ArrayList<String> directoryList = new ArrayList<String>();
        List list = directoriesListSelect.getOptions();
        for (WebElement webElement : list) {
            directoryList.add(webElement.getText());
        }
        return directoryList;
    }

    public WebElement getDirectoryEntryRow(String entryId) {
        List entryElementList = this.directoryEntriesForm.findElements(By.xpath((String)"table/tbody/tr"));
        for (WebElement entryElement : entryElementList) {
            WebElement entryIdElement = entryElement.findElement(By.xpath((String)"td[2]/span"));
            if (!entryId.equals(entryIdElement.getText())) continue;
            return entryElement;
        }
        throw new NoSuchElementException(String.format("Vocabulary entry with id %s not found", entryId));
    }

    public boolean hasEntry(String entryId) {
        try {
            this.getDirectoryEntryRow(entryId);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public VocabulariesPage select(String directoryName) {
        Select directoriesListSelect = new Select(this.directoriesListSelectElement);
        List list = directoriesListSelect.getOptions();
        for (WebElement webElement : list) {
            if (!directoryName.trim().equals(webElement.getText().trim())) continue;
            directoriesListSelect.selectByVisibleText(webElement.getText());
            this.waitForLoading();
            return this.asPage(VocabulariesPage.class);
        }
        throw new NoSuchElementException(String.format("directoryName %s not available", directoryName));
    }

    protected void waitForLoading() {
        try {
            Locator.waitUntilGivenFunctionIgnoring(new Function<WebDriver, Boolean>(){

                public Boolean apply(WebDriver driver) {
                    return driver.findElement(By.id((String)"_viewRoot:status.stop")).getAttribute("style").equals("display: none;");
                }
            }, StaleElementReferenceException.class);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Locator.waitUntilGivenFunctionIgnoring(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return driver.findElement(By.id((String)"_viewRoot:status.start")).getAttribute("style").equals("display: none;");
            }
        }, StaleElementReferenceException.class);
    }
}

