/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter.usermanagement;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UsersGroupsBasePage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UsersTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class UserCreationFormPage
extends UsersGroupsBasePage {
    @Required
    @FindBy(id="createUserView:createUser:immediate_creation")
    WebElement immediateCreation;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_username")
    WebElement usernameInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_firstname")
    WebElement firstnameInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_lastname")
    WebElement lastnameInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_company")
    WebElement companyInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_email")
    WebElement emailInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_firstPassword")
    WebElement firstPasswordInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_secondPassword")
    WebElement secondPasswordInput;
    @FindBy(id="createUserView:createUser:button_save")
    WebElement createButton;
    @Required
    @FindBy(xpath="//div[@class=\"tabsContent\"]//input[@value=\"Cancel\"]")
    WebElement cancelButton;

    public UserCreationFormPage(WebDriver driver) {
        super(driver);
    }

    public UsersGroupsBasePage createUser(String username, String firstname, String lastname, String company, String email, String password, String group) throws NoSuchElementException {
        return this.createUser(username, firstname, lastname, company, email, password, group, false);
    }

    public UsersGroupsBasePage createUser(String username, String firstname, String lastname, String company, String email, String password, String group, boolean invite) throws NoSuchElementException {
        if (!invite) {
            this.switchCreationFormPage();
            this.usernameInput.sendKeys(new CharSequence[]{username});
            this.firstnameInput.sendKeys(new CharSequence[]{firstname});
            this.lastnameInput.sendKeys(new CharSequence[]{lastname});
            this.companyInput.sendKeys(new CharSequence[]{company});
            this.emailInput.sendKeys(new CharSequence[]{email});
            this.firstPasswordInput.sendKeys(new CharSequence[]{password});
            this.secondPasswordInput.sendKeys(new CharSequence[]{password});
            if (StringUtils.isNotBlank((String)group)) {
                Select2WidgetElement groups = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)"//div[@id='s2id_createUserView:createUser:nxl_user:nxw_groups_select2']")), true);
                groups.selectValue(group);
            }
            this.createButton.click();
        }
        return this.asPage(UsersGroupsBasePage.class);
    }

    public UsersTabSubPage cancelCreation() {
        this.cancelButton.click();
        return this.asPage(UsersTabSubPage.class);
    }

    protected void switchCreationFormPage() {
        if (!this.immediateCreation.isSelected()) {
            this.immediateCreation.click();
            Locator.waitUntilElementPresent(By.id((String)"createUserView:createUser:nxl_user:nxw_username"));
        }
    }
}

