/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.util.List;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.ByChained;
import org.openqa.selenium.support.ui.Select;

public class AccessRightsSubPage
extends AbstractPage {
    @Required
    @FindBy(id="add_rights_form:rights_grant_select")
    WebElement selectGrantElement;
    @Required
    @FindBys(value={@FindBy(id="add_rights_form:rights_grant_select"), @FindBy(xpath="//option[@value='Grant']")})
    WebElement selectGrantOption;
    @Required
    @FindBys(value={@FindBy(id="add_rights_form:rights_grant_select"), @FindBy(xpath="//option[@value='Deny']")})
    WebElement selectDenyOption;
    @Required
    @FindBy(id="add_rights_form:rights_permission_select")
    WebElement selectPermissionElement;
    @Required
    @FindBy(id="add_rights_form:rights_add_button")
    WebElement addButton;
    @FindBy(id="validate_rights:document_rights_validate_button")
    WebElement validateButton;

    public AccessRightsSubPage(WebDriver driver) {
        super(driver);
    }

    public boolean hasPermissionForUser(String permission, String username) {
        List trElements = this.driver.findElements((By)new ByChained(new By[]{By.className((String)"dataOutput"), By.tagName((String)"tr")}));
        boolean hasPermission = false;
        for (WebElement trElement : trElements) {
            List tds = trElement.findElements(By.tagName((String)"td"));
            if (tds.size() <= 3) continue;
            String aceUsername = ((WebElement)tds.get(1)).getText();
            String aceGrantedPerm = ((WebElement)tds.get(2)).getText();
            String aceDeniedPerm = ((WebElement)tds.get(3)).getText();
            if (!username.equals(aceUsername)) continue;
            if (aceGrantedPerm.equals(permission) || "Manage everything".equals(aceGrantedPerm)) {
                hasPermission = true;
                continue;
            }
            if (!aceDeniedPerm.equals(permission) && !"Manage everything".equals(aceDeniedPerm)) continue;
            hasPermission = false;
        }
        return hasPermission;
    }

    public AccessRightsSubPage addPermissionForUser(String username, String permission, boolean grant) {
        Select2WidgetElement userSelection = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)"//*[@id='s2id_add_rights_form:nxl_user_group_suggestion:nxw_selection_select2']")), true);
        userSelection.selectValue(username);
        Select selectGrant = new Select(this.selectGrantElement);
        if (grant) {
            selectGrant.selectByValue("Grant");
        } else {
            selectGrant.selectByValue("Deny");
        }
        Select selectPermission = new Select(this.selectPermissionElement);
        selectPermission.selectByVisibleText(permission);
        this.addButton.click();
        return this.asPage(AccessRightsSubPage.class).saveChanges();
    }

    public AccessRightsSubPage saveChanges() {
        AccessRightsSubPage.waitUntilEnabled(this.validateButton);
        this.validateButton.click();
        return this.asPage(AccessRightsSubPage.class);
    }
}

