/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import com.google.common.base.Function;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Select;

public class RelationTabSubPage
extends DocumentBasePage {
    private static final Log log = LogFactory.getLog(RelationTabSubPage.class);
    private static final int CREATE_FORM_LOADING_TIMEOUT = 20;
    private static final int SELECT2_CHANGE_TIMEOUT = 4;
    private static final String OBJECT_DOCUMENT_UID_ID = "createForm:objectDocumentUid";
    private static final String SELECT2_DOCUMENT_XPATH = "//*[@id='s2id_createForm:nxw_singleDocumentSuggestion_select2']";
    @Required
    @FindBy(linkText="Add a new relation")
    WebElement addANewRelationLink;
    @FindBy(id="createForm")
    WebElement createRelationForm;
    @FindBy(xpath="//*[@id='createForm']/table/tbody/tr[4]/td[2]/input")
    WebElement addButton;
    @FindBy(id="createForm:predicateUri")
    WebElement predicate;
    @FindBy(name="createForm:objectType")
    List<WebElement> objectCheckBoxList;
    @FindBy(xpath="//*[@id='document_relations']/table/tbody/tr")
    List<WebElement> existingRelations;

    public RelationTabSubPage(WebDriver driver) {
        super(driver);
    }

    public RelationTabSubPage deleteRelation(int index) {
        this.getExistingRelations().get(index).findElement(By.linkText((String)"Delete")).click();
        return this.asPage(RelationTabSubPage.class);
    }

    public List<WebElement> getExistingRelations() {
        return this.existingRelations;
    }

    public RelationTabSubPage initRelationSetUp() {
        this.addANewRelationLink.click();
        Function<WebDriver, Boolean> createRelationFormVisible = new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RelationTabSubPage.this.createRelationForm != null;
            }
        };
        FluentWait wait = new FluentWait((Object)this.driver).withTimeout(20L, TimeUnit.SECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class);
        wait.until((Function)createRelationFormVisible);
        return this.asPage(RelationTabSubPage.class);
    }

    private boolean isObjectChecked(int index) {
        assert (index < 3 && index >= 0);
        Assert.assertNotNull(this.objectCheckBoxList);
        Assert.assertEquals((long)3L, (long)this.objectCheckBoxList.size());
        return this.objectCheckBoxList.get(index).isSelected();
    }

    public boolean isObjectDocumentChecked() {
        return this.isObjectChecked(2);
    }

    public RelationTabSubPage setRelationWithDocument(String documentName, String predicateUri) {
        Assert.assertFalse((boolean)this.isObjectDocumentChecked());
        Select predicateSelect = new Select(this.predicate);
        predicateSelect.selectByValue(predicateUri);
        Select2WidgetElement documentSuggestionWidget = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)SELECT2_DOCUMENT_XPATH)));
        documentSuggestionWidget.selectValue(documentName);
        Function<WebDriver, Boolean> isDocumentSelected = new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                WebElement selectedDocument = driver.findElement(By.id((String)RelationTabSubPage.OBJECT_DOCUMENT_UID_ID));
                String value = selectedDocument.getAttribute("value");
                boolean result = StringUtils.isNotBlank((String)value);
                if (!result) {
                    log.debug((Object)"Waiting for select2 ajaxReRender");
                }
                return result;
            }
        };
        Assert.assertTrue((boolean)this.isObjectDocumentChecked());
        FluentWait wait = new FluentWait((Object)this.driver).withTimeout(4L, TimeUnit.SECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS).ignoring(StaleElementReferenceException.class);
        wait.until((Function)isDocumentSelected);
        if (log.isDebugEnabled()) {
            WebElement selectedDocument = this.driver.findElement(By.id((String)OBJECT_DOCUMENT_UID_ID));
            log.debug((Object)("Submitting relation on document: " + selectedDocument.getAttribute("value")));
        }
        this.addButton.click();
        return this.asPage(RelationTabSubPage.class);
    }
}

