/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.browsermob.proxy.ProxyServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.LogTestWatchman;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.VariableElementLocatorFactory;
import org.nuxeo.functionaltests.fragment.WebFragment;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.nuxeo.functionaltests.pages.FileDocumentBasePage;
import org.nuxeo.functionaltests.pages.LoginPage;
import org.nuxeo.functionaltests.pages.NoteDocumentBasePage;
import org.nuxeo.functionaltests.pages.forms.CollectionCreationFormPage;
import org.nuxeo.functionaltests.pages.forms.DublinCoreCreationDocumentFormPage;
import org.nuxeo.functionaltests.pages.forms.FileCreationFormPage;
import org.nuxeo.functionaltests.pages.forms.NoteCreationFormPage;
import org.nuxeo.functionaltests.pages.forms.WorkspaceFormPage;
import org.nuxeo.functionaltests.pages.tabs.CollectionContentTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.ui.FluentWait;

public abstract class AbstractTest {
    public static final String TEST_USERNAME = "jdoe";
    public static final String TEST_PASSWORD = "test";
    public static final int POLLING_FREQUENCY_MILLISECONDS = 100;
    public static final int PAGE_LOAD_TIME_OUT_SECONDS = 60;
    public static final String CHROME_DRIVER_DEFAULT_PATH_LINUX = "/usr/bin/chromedriver";
    public static final String CHROME_DRIVER_DEFAULT_PATH_MAC = "/Applications/chromedriver";
    public static final String CHROME_DRIVER_DEFAULT_PATH_WINVISTA = SystemUtils.getUserHome().getPath() + "\\AppData\\Local\\Google\\Chrome\\Application\\chromedriver.exe";
    public static final String CHROME_DRIVER_DEFAULT_PATH_WINXP = SystemUtils.getUserHome().getPath() + "\\Local Settings\\Application Data\\Google\\Chrome\\Application\\chromedriver.exe";
    public static final String CHROME_DRIVER_DEFAULT_EXECUTABLE_NAME = "chromedriver";
    public static final String CHROME_DRIVER_WINDOWS_EXECUTABLE_NAME = "chromedriver.exe";
    static final Log log = LogFactory.getLog(AbstractTest.class);
    public static final String NUXEO_URL = System.getProperty("nuxeoURL", "http://localhost:8080/nuxeo").replaceAll("/$", "");
    public static final int LOAD_TIMEOUT_SECONDS = 30;
    public static final int LOAD_SHORT_TIMEOUT_SECONDS = 2;
    public static final int AJAX_TIMEOUT_SECONDS = 10;
    public static final int AJAX_SHORT_TIMEOUT_SECONDS = 2;
    public static final int POLLING_FREQUENCY_SECONDS = 1;
    private static final String FIREBUG_XPI = "firebug-1.6.2-fx.xpi";
    private static final String FIREBUG_VERSION = "1.6.2";
    private static final String FIREBUG_M2 = "firebug/firebug/1.6.2-fx";
    private static final int PROXY_PORT = 4444;
    private static final String HAR_NAME = "http-headers.json";
    public static final String SYSPROP_CHROME_DRIVER_PATH = "webdriver.chrome.driver";
    protected static RemoteWebDriver driver;
    protected static File tmp_firebug_xpi;
    protected static ProxyServer proxyServer;
    @Rule
    public MethodRule watchman = new LogTestWatchman(driver, NUXEO_URL);
    private static final String M2_REPO = "repository/";

    public void runBeforeAfters() {
        ((LogTestWatchman)this.watchman).runBeforeAfters();
    }

    @BeforeClass
    public static void initDriver() throws Exception {
        String browser = System.getProperty("browser", "firefox");
        if (browser.equals("chrome") || browser.equals("firefox")) {
            AbstractTest.initFirefoxDriver();
        } else if (browser.equals("googlechrome")) {
            AbstractTest.initChromeDriver();
        } else {
            throw new RuntimeException("Browser not supported: " + browser);
        }
        driver.manage().timeouts().pageLoadTimeout(60L, TimeUnit.SECONDS);
    }

    protected static void initFirefoxDriver() throws Exception {
        DesiredCapabilities dc = DesiredCapabilities.firefox();
        FirefoxProfile profile = new FirefoxProfile();
        profile.setEnableNativeEvents(false);
        profile.setPreference("general.useragent.locale", "en");
        profile.setPreference("intl.accept_languages", "en");
        profile.setPreference("network.http.keep-alive", true);
        profile.setPreference("network.http.pipelining", true);
        profile.setPreference("network.http.proxy.pipelining", true);
        profile.setPreference("network.http.pipelining.maxrequests", 8);
        profile.setPreference("browser.sessionhistory.max_entries", 10);
        profile.setPreference("browser.sessionhistory.max_total_viewers", 4);
        profile.setPreference("browser.sessionstore.max_tabs_undo", 4);
        profile.setPreference("browser.sessionstore.interval", 1800000);
        profile.setPreference("dom.max_script_run_time", 0);
        profile.setPreference("dom.max_chrome_script_run_time", 0);
        profile.setPreference("network.proxy.no_proxies_on", "");
        profile.setPreference("browser.tabs.warnOnClose", false);
        profile.setPreference("browser.tabs.warnOnOpen", false);
        profile.setPreference("extensions.newAddons", false);
        profile.setPreference("extensions.update.notifyUser", false);
        profile.setPreference("browser.urlbar.autocomplete.enabled", false);
        profile.setPreference("browser.download.useDownloadDir", false);
        profile.setPreference("toolkit.networkmanager.disable", true);
        profile.setPreference("datareporting.policy.dataSubmissionEnabled", false);
        profile.setPreference("datareporting.healthreport.uploadEnabled", false);
        profile.setPreference("datareporting.healthreport.service.firstRun", false);
        profile.setPreference("datareporting.healthreport.service.enabled", false);
        profile.setPreference("datareporting.healthreport.logging.consoleEnabled", false);
        profile.setPreference("browser.startup.homepage", "about:blank");
        profile.setPreference("pref.browser.homepage.disable_button.bookmark_page", false);
        profile.setPreference("pref.browser.homepage.disable_button.restore_default", false);
        profile.setPreference("browser.search.update", false);
        profile.setPreference("browser.bookmarks.restore_default_bookmarks", false);
        profile.setPreference("extensions.ui.dictionary.hidden", true);
        profile.setPreference("layout.spellcheckDefault", 0);
        if (Boolean.TRUE.equals(Boolean.valueOf(System.getenv("nuxeo.log.webriver")))) {
            String location = System.getProperty("basedir") + File.separator + "target";
            File outputFolder = new File(location);
            if (!outputFolder.exists() || !outputFolder.isDirectory()) {
                outputFolder = null;
            }
            File webdriverlogFile = File.createTempFile("webdriver", ".log", outputFolder);
            profile.setPreference("webdriver.log.file", webdriverlogFile.getAbsolutePath());
            log.warn((Object)("Webdriver logs saved in " + webdriverlogFile));
        }
        AbstractTest.addFireBug(profile);
        Proxy proxy = AbstractTest.startProxy();
        if (proxy != null) {
            proxy.setNoProxy("");
            profile.setProxyPreferences(proxy);
        }
        dc.setCapability("firefox_profile", (Object)profile);
        driver = new FirefoxDriver((Capabilities)dc);
    }

    protected static void initChromeDriver() throws Exception {
        if (System.getProperty(SYSPROP_CHROME_DRIVER_PATH) == null) {
            String chromeDriverDefaultPath = null;
            String chromeDriverExecutableName = CHROME_DRIVER_DEFAULT_EXECUTABLE_NAME;
            if (SystemUtils.IS_OS_LINUX) {
                chromeDriverDefaultPath = CHROME_DRIVER_DEFAULT_PATH_LINUX;
            } else if (SystemUtils.IS_OS_MAC) {
                chromeDriverDefaultPath = CHROME_DRIVER_DEFAULT_PATH_MAC;
            } else if (SystemUtils.IS_OS_WINDOWS_XP) {
                chromeDriverDefaultPath = CHROME_DRIVER_DEFAULT_PATH_WINXP;
                chromeDriverExecutableName = CHROME_DRIVER_WINDOWS_EXECUTABLE_NAME;
            } else if (SystemUtils.IS_OS_WINDOWS_VISTA) {
                chromeDriverDefaultPath = CHROME_DRIVER_DEFAULT_PATH_WINVISTA;
                chromeDriverExecutableName = CHROME_DRIVER_WINDOWS_EXECUTABLE_NAME;
            } else if (SystemUtils.IS_OS_WINDOWS) {
                chromeDriverExecutableName = CHROME_DRIVER_WINDOWS_EXECUTABLE_NAME;
            }
            if (chromeDriverDefaultPath != null && new File(chromeDriverDefaultPath).exists()) {
                log.warn((Object)String.format("Missing property %s but found %s. Using it...", SYSPROP_CHROME_DRIVER_PATH, chromeDriverDefaultPath));
                System.setProperty(SYSPROP_CHROME_DRIVER_PATH, chromeDriverDefaultPath);
            } else {
                File chromeDriverExecutable = AbstractTest.findExecutableOnPath(chromeDriverExecutableName);
                if (chromeDriverExecutable != null && chromeDriverExecutable.exists()) {
                    log.warn((Object)String.format("Missing property %s but found %s. Using it...", SYSPROP_CHROME_DRIVER_PATH, chromeDriverExecutable.getCanonicalPath()));
                    System.setProperty(SYSPROP_CHROME_DRIVER_PATH, chromeDriverExecutable.getCanonicalPath());
                } else {
                    log.error((Object)String.format("Could not find the Chrome driver looking at %s or system path. Download it from %s and set its path with the System property %s.", chromeDriverDefaultPath, "http://code.google.com/p/chromedriver/downloads/list", SYSPROP_CHROME_DRIVER_PATH));
                }
            }
        }
        DesiredCapabilities dc = DesiredCapabilities.chrome();
        ChromeOptions options = new ChromeOptions();
        options.addArguments(Arrays.asList("--ignore-certificate-errors"));
        Proxy proxy = AbstractTest.startProxy();
        if (proxy != null) {
            proxy.setNoProxy("");
            dc.setCapability("proxy", (Object)proxy);
        }
        dc.setCapability("chromeOptions", (Object)options);
        driver = new ChromeDriver((Capabilities)dc);
    }

    protected static File findExecutableOnPath(String executableName) {
        String systemPath = System.getenv("PATH");
        String[] pathDirs = systemPath.split(File.pathSeparator);
        File fullyQualifiedExecutable = null;
        for (String pathDir : pathDirs) {
            File file = new File(pathDir, executableName);
            if (!file.isFile()) continue;
            fullyQualifiedExecutable = file;
            break;
        }
        return fullyQualifiedExecutable;
    }

    @AfterClass
    public static void quitDriver() {
        if (driver != null) {
            driver.quit();
            driver = null;
        }
        AbstractTest.removeFireBug();
        try {
            AbstractTest.stopProxy();
        }
        catch (Exception e) {
            System.err.println("Could not stop proxy: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> getClassLoaderFiles() throws Exception {
        URL url;
        URI uri;
        String cp;
        ClassLoader cl = AbstractTest.class.getClassLoader();
        URL[] urls = null;
        if (cl instanceof URLClassLoader) {
            urls = ((URLClassLoader)cl).getURLs();
        } else if (cl.getClass().getName().equals("org.apache.tools.ant.AntClassLoader")) {
            Method method = cl.getClass().getMethod("getClasspath", new Class[0]);
            cp = (String)method.invoke((Object)cl, new Object[0]);
            String[] paths = cp.split(File.pathSeparator);
            urls = new URL[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                urls[i] = new URL("file:" + paths[i]);
            }
        } else {
            System.err.println("Unknown classloader type: " + cl.getClass().getName());
            return null;
        }
        JarFile surefirebooterJar = null;
        URL[] arr$ = urls;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(uri = (url = arr$[i$]).toURI()).getPath().matches(".*/nuxeo-runtime-[^/]*\\.jar"); ++i$) {
            if (!uri.getScheme().equals("file") || !uri.getPath().contains("surefirebooter")) continue;
            surefirebooterJar = new JarFile(new File(uri));
        }
        if (surefirebooterJar != null) {
            try {
                try {
                    cp = surefirebooterJar.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                    if (cp != null) {
                        String[] cpe = cp.split(" ");
                        URL[] newUrls = new URL[cpe.length];
                        for (int i = 0; i < cpe.length; ++i) {
                            String newUrl = cpe[i].startsWith("file:") ? cpe[i] : "file:" + cpe[i];
                            newUrls[i] = new URL(newUrl);
                        }
                        urls = newUrls;
                    }
                }
                finally {
                    surefirebooterJar.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ArrayList<String> files = new ArrayList<String>(urls.length);
        for (URL url2 : urls) {
            files.add(url2.toURI().getPath());
        }
        return files;
    }

    protected static void addFireBug(FirefoxProfile profile) throws Exception {
        File xpi = null;
        List<String> clf = AbstractTest.getClassLoaderFiles();
        for (String f : clf) {
            if (!f.endsWith("/firebug-1.6.2-fx.xpi")) continue;
            xpi = new File(f);
        }
        if (xpi == null) {
            String customM2Repo = System.getProperty("M2_REPO", M2_REPO).replaceAll("/$", "");
            for (String f : clf) {
                if (!f.contains(customM2Repo)) continue;
                String m2 = f.substring(0, f.indexOf(customM2Repo) + customM2Repo.length());
                xpi = new File(m2 + "/" + FIREBUG_M2 + "/" + FIREBUG_XPI);
                break;
            }
        }
        if (xpi == null || !xpi.exists()) {
            log.warn((Object)"firebug-1.6.2-fx.xpi not found in classloader or local M2 repository");
            return;
        }
        profile.addExtension(xpi);
        profile.setPreference("extensions.firebug.currentVersion", FIREBUG_VERSION);
    }

    protected static void removeFireBug() {
        if (tmp_firebug_xpi != null) {
            tmp_firebug_xpi.delete();
            tmp_firebug_xpi.getParentFile().delete();
        }
    }

    protected static Proxy startProxy() throws Exception {
        if (Boolean.TRUE.equals(Boolean.valueOf(System.getProperty("useProxy", "false")))) {
            proxyServer = new ProxyServer(4444);
            proxyServer.start();
            proxyServer.setCaptureHeaders(true);
            proxyServer.blacklistRequests("https?://www\\.nuxeo\\.com/embedded/wizard.*", 410);
            proxyServer.blacklistRequests("https?://.*\\.mktoresp\\.com/.*", 410);
            proxyServer.blacklistRequests(".*_mchId.*", 410);
            proxyServer.blacklistRequests("https?://.*\\.google-analytics\\.com/.*", 410);
            proxyServer.newHar("webdriver-test");
            Proxy proxy = proxyServer.seleniumProxy();
            return proxy;
        }
        return null;
    }

    protected static void stopProxy() throws Exception {
        if (proxyServer != null) {
            String target = System.getProperty("nuxeo.log.dir");
            File harFile = target == null ? new File(HAR_NAME) : new File(target, HAR_NAME);
            proxyServer.getHar().writeTo(harFile);
            proxyServer.stop();
        }
    }

    public static <T> T get(String url, Class<T> pageClassToProxy) {
        driver.get(url);
        return AbstractTest.asPage(pageClassToProxy);
    }

    public static <T> T getWithoutErrorHandler(String url, Class<T> pageClassToProxy) throws IOException {
        Command command = new Command(driver.getSessionId(), "get", (Map)ImmutableMap.of((Object)"url", (Object)url));
        driver.getCommandExecutor().execute(command);
        return AbstractTest.asPage(pageClassToProxy);
    }

    public static WebDriver getPopup() {
        String currentWindow = driver.getWindowHandle();
        for (String popup : driver.getWindowHandles()) {
            if (popup.equals(currentWindow)) continue;
            return driver.switchTo().window(popup);
        }
        return null;
    }

    public static <T> T asPage(Class<T> pageClassToProxy) {
        T page = AbstractTest.instantiatePage(pageClassToProxy);
        return AbstractTest.fillElement(pageClassToProxy, page);
    }

    public static <T extends WebFragment> T getWebFragment(By by, Class<T> webFragmentClass) {
        WebElement element = Locator.findElementWithTimeout(by);
        return AbstractTest.getWebFragment(element, webFragmentClass);
    }

    public static <T extends WebFragment> T getWebFragment(WebElement element, Class<T> webFragmentClass) {
        Object webFragment = AbstractTest.instantiateWebFragment(element, webFragmentClass);
        webFragment = (WebFragment)AbstractTest.fillElement(webFragmentClass, webFragment);
        webFragment.setElement(element);
        return (T)webFragment;
    }

    public static <T> T fillElement(Class<T> pageClassToProxy, T page) {
        PageFactory.initElements((ElementLocatorFactory)new VariableElementLocatorFactory((WebDriver)driver, 10), page);
        final ArrayList<String> fieldNames = new ArrayList<String>();
        final ArrayList<WrapsElement> elements = new ArrayList<WrapsElement>();
        for (Field field : pageClassToProxy.getDeclaredFields()) {
            if (field.getAnnotation(Required.class) == null) continue;
            try {
                field.setAccessible(true);
                fieldNames.add(field.getName());
                elements.add((WrapsElement)field.get(page));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        FluentWait wait = new FluentWait(page).withTimeout(30L, TimeUnit.SECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS);
        return (T)wait.until(new Function<T, T>(){

            public T apply(T page) {
                String notLoaded = AbstractTest.anyElementNotLoaded(elements, fieldNames);
                if (notLoaded == null) {
                    return page;
                }
                log.debug((Object)("not loaded:" + notLoaded));
                return null;
            }
        });
    }

    protected static String anyElementNotLoaded(List<WrapsElement> proxies, List<String> fieldNames) {
        for (int i = 0; i < proxies.size(); ++i) {
            WrapsElement proxy = proxies.get(i);
            try {
                proxy.getWrappedElement();
                continue;
            }
            catch (NoSuchElementException e) {
                return fieldNames.get(i);
            }
        }
        return null;
    }

    protected static <T> T instantiatePage(Class<T> pageClassToProxy) {
        try {
            try {
                Constructor<T> constructor = pageClassToProxy.getConstructor(WebDriver.class);
                return constructor.newInstance(driver);
            }
            catch (NoSuchMethodException e) {
                return pageClassToProxy.newInstance();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends WebFragment> T instantiateWebFragment(WebElement element, Class<T> webFragmentClass) {
        try {
            try {
                Constructor<T> constructor = webFragmentClass.getConstructor(WebDriver.class, WebElement.class);
                return (T)((WebFragment)constructor.newInstance(driver, element));
            }
            catch (NoSuchMethodException e) {
                return (T)((WebFragment)webFragmentClass.newInstance());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public LoginPage getLoginPage() {
        return AbstractTest.get(NUXEO_URL + "/logout", LoginPage.class);
    }

    public LoginPage logout() {
        return this.getLoginPage();
    }

    public <T extends AbstractPage> T nav(Class<T> pageClass, String linkText) {
        WebElement link = Locator.findElementWithTimeout(By.linkText((String)linkText));
        if (link == null) {
            return null;
        }
        link.click();
        return (T)((AbstractPage)AbstractTest.asPage(pageClass));
    }

    public void navToUrl(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        driver.navigate().to(url);
    }

    public DocumentBasePage login() throws DocumentBasePage.UserNotConnectedException {
        return this.login("Administrator", "Administrator");
    }

    public DocumentBasePage login(String username, String password) throws DocumentBasePage.UserNotConnectedException {
        DocumentBasePage documentBasePage = this.getLoginPage().login(username, password, DocumentBasePage.class);
        documentBasePage.checkUserConnected(username);
        return documentBasePage;
    }

    public DocumentBasePage loginAsTestUser() throws DocumentBasePage.UserNotConnectedException {
        return this.login(TEST_USERNAME, TEST_PASSWORD);
    }

    public LoginPage loginInvalid(String username, String password) {
        LoginPage loginPage = this.getLoginPage().login(username, password, LoginPage.class);
        return loginPage;
    }

    protected DocumentBasePage initRepository(DocumentBasePage currentPage) throws Exception {
        return this.createWorkspace(currentPage, "Test Workspace", "Test Workspace for my dear WebDriver.");
    }

    protected void cleanRepository(DocumentBasePage currentPage) throws Exception {
        this.deleteWorkspace(currentPage, "Test Workspace");
    }

    protected DocumentBasePage createWorkspace(DocumentBasePage currentPage, String workspaceTitle, String workspaceDescription) {
        DocumentBasePage workspacesPage = currentPage.getNavigationSubPage().goToDocument("Workspaces");
        WorkspaceFormPage workspaceCreationFormPage = workspacesPage.getWorkspacesContentTab().getWorkspaceCreatePage();
        DocumentBasePage workspacePage = workspaceCreationFormPage.createNewWorkspace(workspaceTitle, workspaceDescription);
        return workspacePage;
    }

    protected void deleteWorkspace(DocumentBasePage currentPage, String workspaceTitle) {
        DocumentBasePage workspacesPage = currentPage.getNavigationSubPage().goToDocument("Workspaces");
        workspacesPage.getContentTab().removeDocument(workspaceTitle);
    }

    protected FileDocumentBasePage createFile(DocumentBasePage currentPage, String fileTitle, String fileDescription, boolean uploadBlob, String filePrefix, String fileSuffix, String fileContent) throws IOException {
        FileCreationFormPage fileCreationFormPage = currentPage.getContentTab().getDocumentCreatePage("File", FileCreationFormPage.class);
        FileDocumentBasePage filePage = fileCreationFormPage.createFileDocument(fileTitle, fileDescription, uploadBlob, filePrefix, fileSuffix, fileDescription);
        return filePage;
    }

    protected DocumentBasePage createCollections(DocumentBasePage currentPage, String collectionsTitle, String fileDescription) {
        DublinCoreCreationDocumentFormPage dublinCoreDocumentFormPage = currentPage.getContentTab().getDocumentCreatePage("Collections", DublinCoreCreationDocumentFormPage.class);
        DocumentBasePage documentBasePage = dublinCoreDocumentFormPage.createDocument(collectionsTitle, fileDescription);
        return documentBasePage;
    }

    protected CollectionContentTabSubPage createCollection(DocumentBasePage currentPage, String collectionsTitle, String fileDescription) {
        CollectionCreationFormPage collectionCreationFormPage = currentPage.getContentTab().getDocumentCreatePage("Collection", CollectionCreationFormPage.class);
        CollectionContentTabSubPage documentBasePage = collectionCreationFormPage.createDocument(collectionsTitle, fileDescription);
        return documentBasePage;
    }

    public static String getTmpFileToUploadPath(String filePrefix, String fileSuffix, String fileContent) throws IOException {
        File tmpFile = File.createTempFile(filePrefix, fileSuffix);
        tmpFile.deleteOnExit();
        FileUtils.writeFile((File)tmpFile, (String)fileContent);
        Assert.assertTrue((boolean)tmpFile.exists());
        Assert.assertEquals((Object)"file", (Object)tmpFile.toURI().toURL().getProtocol());
        return tmpFile.getAbsolutePath();
    }

    protected String getCurrentDocumentId() {
        return (String)driver.executeScript(String.format("return ctx.currentDocument;", new Object[0]), new Object[0]);
    }

    protected NoteDocumentBasePage createNote(DocumentBasePage currentPage, String noteTitle, String noteDescription, boolean defineNote, String noteContent) throws IOException {
        NoteCreationFormPage noteCreationPage = currentPage.getContentTab().getDocumentCreatePage("Note", NoteCreationFormPage.class);
        NoteDocumentBasePage notePage = noteCreationPage.createNoteDocument(noteTitle, noteDescription, defineNote, noteContent);
        return notePage;
    }

    static {
        proxyServer = null;
    }
}

