/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.contentView;

import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class ContentViewElement
extends WebFragmentImpl {
    @FindBy(className="contentViewUpperActions")
    @Required
    private WebElement upperActions;

    public ContentViewElement(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    public WebElement getActionByTitle(String title) {
        return this.upperActions.findElement(By.xpath((String)("//img[@alt=\"" + title + "\"]")));
    }

    public void switchToResultLayout(ResultLayout layout) {
        AjaxRequestManager a = new AjaxRequestManager(this.driver);
        a.watchAjaxRequests();
        this.getActionByTitle(layout.title).click();
        a.waitForAjaxRequests();
    }

    public static enum ResultLayout {
        THUMBNAIL("Thumbnail view"),
        LISTING("List view");

        private final String title;

        private ResultLayout(String title) {
            this.title = title;
        }
    }
}

