/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.forms;

import java.util.Arrays;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.fragment.WebFragmentImpl;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class NewVocabularyEntryForm
extends WebFragmentImpl {
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_label_en")
    @Required
    private WebElement englishLabelInput;
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_label_fr")
    @Required
    private WebElement frenchLabelInput;
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_id")
    @Required
    private WebElement idInput;
    @FindBy(id="nxw_parent_openPopup")
    private WebElement newParentPopup;
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_obsolete_checkbox")
    @Required
    private WebElement notObsoleteInput;
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_obsolete_checkbox")
    @Required
    private WebElement obsoleteInput;
    @FindBy(id="addEntryView:addEntryForm:nxl_l10nsubjects_vocabulary:nxw_l10nxvocabulary_order")
    @Required
    private WebElement orderInput;

    public NewVocabularyEntryForm(WebDriver driver, WebElement element) {
        super(driver, element);
    }

    private void findParentNodeAndSelect(WebElement selectParentFancyBox, String[] path) {
        if (path.length == 1) {
            selectParentFancyBox.findElement(By.linkText((String)path[0])).click();
        } else {
            WebElement node = selectParentFancyBox.findElement(By.xpath((String)("//table[contains(text(),'" + path[0] + "')]")));
            node.findElement(By.xpath((String)"tbody/tr[1]/td[1]/div/a")).click();
            this.findParentNodeAndSelect(selectParentFancyBox, Arrays.copyOfRange(path, 1, path.length));
        }
    }

    public void save() {
        this.getElement().findElement(By.xpath((String)"//input[@value='Create']")).click();
    }

    public void setNewVocabularyEnglishLabel(String vocabularyEnglishLabel) {
        this.englishLabelInput.sendKeys(new CharSequence[]{vocabularyEnglishLabel});
    }

    public void setNewVocabularyFrenchLabel(String vocabularyFrenchLabel) {
        this.frenchLabelInput.sendKeys(new CharSequence[]{vocabularyFrenchLabel});
    }

    public void setNewVocabularyId(String vocabularyId) {
        this.idInput.sendKeys(new CharSequence[]{vocabularyId});
    }

    public void setNewVocabularyObsolete(boolean obsolete) {
        if (obsolete) {
            this.obsoleteInput.click();
        } else {
            this.notObsoleteInput.click();
        }
    }

    public void setNewVocabularyOrder(int vocabularyOrder) {
        this.orderInput.clear();
        this.orderInput.sendKeys(new CharSequence[]{vocabularyOrder + ""});
    }

    public void setNewVocabularyParentId(String parentLabelPath) {
        this.newParentPopup.click();
        WebElement selectParentFancyBox = Locator.findElementWithTimeout(By.id((String)"fancybox-content"));
        String[] split = parentLabelPath.split("/");
        this.findParentNodeAndSelect(selectParentFancyBox, split);
    }
}

