/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.AddToCollectionForm;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.HomePage;
import org.nuxeo.functionaltests.pages.NavigationSubPage;
import org.nuxeo.functionaltests.pages.UserHomePage;
import org.nuxeo.functionaltests.pages.actions.ContextualActions;
import org.nuxeo.functionaltests.pages.admincenter.AdminCenterBasePage;
import org.nuxeo.functionaltests.pages.search.SearchPage;
import org.nuxeo.functionaltests.pages.tabs.CollectionContentTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.ContentTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.EditTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.HistoryTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.ManageTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.RelationTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.SummaryTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.WorkflowTabSubPage;
import org.nuxeo.functionaltests.pages.tabs.WorkspacesContentTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class DocumentBasePage
extends AbstractPage {
    @FindBy(xpath="//form[@id='breadcrumbForm']")
    public WebElement breadcrumbForm;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Content']")
    public WebElement contentTabLink;
    public ContextualActions contextualActions;
    @FindBy(className="creator")
    public WebElement currentDocumentContributor;
    @FindBy(className="documentDescription")
    public WebElement currentDocumentDescription;
    @FindBy(xpath="/html/body/table[2]/tbody/tr/td[2]/div[2]//h1")
    public WebElement currentDocumentTitle;
    @FindBy(className="currentDocumentDescription")
    public WebElement currentFolderishDescription;
    @FindBy(linkText="WORKSPACE")
    public WebElement documentManagementLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Edit']")
    public WebElement editTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='History']")
    public WebElement historyTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Manage']")
    public WebElement manageTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Relations']")
    public WebElement relationTabLink;
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']//a/span[text()='Summary']")
    public WebElement summaryTabLink;
    @Required
    @FindBy(xpath="//div[@id='nxw_documentTabs_panel']")
    public WebElement tabsBar;
    @FindBy(linkText="Workflow")
    public WebElement workflowLink;
    @Required
    @FindBy(id="nxw_userMenuActions_panel")
    public WebElement userMenuActions;
    @Required
    @FindBy(linkText="HOME")
    public WebElement homePageLink;
    @Required
    @FindBy(linkText="SEARCH")
    public WebElement searchPageLink;
    private static final String ADD_TO_COLLECTION_UPPER_ACTION_ID = "nxw_addToCollectionAction_form:nxw_documentActionsUpperButtons_addToCollectionAction_subview:nxw_documentActionsUpperButtons_addToCollectionAction_link";
    private static final String ADD_ALL_TO_COLLECTION_ACTION_ID = "document_content_buttons:nxw_addSelectedToCollectionAction_form:nxw_cvButton_addSelectedToCollectionAction_subview:nxw_cvButton_addSelectedToCollectionAction_link";
    @FindBy(id="nxw_addToCollectionAction_form:nxw_documentActionsUpperButtons_addToCollectionAction_subview:nxw_documentActionsUpperButtons_addToCollectionAction_link")
    private WebElement addToCollectionUpperAction;
    @FindBy(id="document_content_buttons:nxw_addSelectedToCollectionAction_form:nxw_cvButton_addSelectedToCollectionAction_subview:nxw_cvButton_addSelectedToCollectionAction_link")
    private WebElement addAllToCollectionAction;

    public DocumentBasePage(WebDriver driver) {
        super(driver);
    }

    public void checkDocTitle(String expectedTitle) {
        Assert.assertEquals((Object)expectedTitle, (Object)this.getCurrentDocumentTitle());
    }

    public void checkUserConnected(String username) throws UserNotConnectedException {
        if (!this.getHeaderLinks().getText().contains(username)) {
            throw new UserNotConnectedException(username);
        }
    }

    protected void clickOnLinkIfNotSelected(WebElement tabLink) {
        WebElement selectedTab = DocumentBasePage.findElementWithTimeout(By.xpath((String)"//div[@id='nxw_documentTabs_panel']//li[@class='selected']/a/span"));
        if (!selectedTab.equals(tabLink)) {
            tabLink.click();
        }
    }

    public AdminCenterBasePage getAdminCenter() {
        DocumentBasePage.findElementWithTimeout(By.linkText((String)"ADMIN")).click();
        return this.asPage(AdminCenterBasePage.class);
    }

    public ContentTabSubPage getContentTab() {
        return this.getContentTab(ContentTabSubPage.class);
    }

    public <T extends ContentTabSubPage> T getContentTab(Class<T> tabClass) {
        this.clickOnLinkIfNotSelected(this.contentTabLink);
        return (T)((ContentTabSubPage)this.asPage(tabClass));
    }

    public CollectionContentTabSubPage getCollectionContentTab() {
        return this.getContentTab(CollectionContentTabSubPage.class);
    }

    public ContextualActions getContextualActions() {
        return this.asPage(ContextualActions.class);
    }

    public String getCurrentContributors() {
        return this.currentDocumentContributor.getText();
    }

    public String getCurrentDocumentDescription() {
        return this.currentDocumentDescription.getText();
    }

    public String getCurrentDocumentTitle() {
        return this.currentDocumentTitle.getText();
    }

    public String getCurrentFolderishDescription() {
        return this.currentFolderishDescription.getText();
    }

    public List<String> getCurrentStates() {
        List<WebElement> states = DocumentBasePage.findElementsWithTimeout(By.className((String)"sticker"));
        ArrayList<String> stateLabels = new ArrayList<String>();
        for (WebElement state : states) {
            stateLabels.add(state.getText());
        }
        return stateLabels;
    }

    public DocumentBasePage getDocumentManagement() {
        this.documentManagementLink.click();
        return this.asPage(DocumentBasePage.class);
    }

    public EditTabSubPage getEditTab() {
        this.clickOnLinkIfNotSelected(this.editTabLink);
        return this.asPage(EditTabSubPage.class);
    }

    public HistoryTabSubPage getHistoryTab() {
        this.clickOnLinkIfNotSelected(this.historyTabLink);
        return this.asPage(HistoryTabSubPage.class);
    }

    public ManageTabSubPage getManageTab() {
        this.clickOnLinkIfNotSelected(this.manageTabLink);
        return this.asPage(ManageTabSubPage.class);
    }

    public NavigationSubPage getNavigationSubPage() {
        return this.asPage(NavigationSubPage.class);
    }

    public RelationTabSubPage getRelationTab() {
        this.clickOnLinkIfNotSelected(this.relationTabLink);
        return this.asPage(RelationTabSubPage.class);
    }

    public SummaryTabSubPage getSummaryTab() {
        this.clickOnLinkIfNotSelected(this.summaryTabLink);
        return this.asPage(SummaryTabSubPage.class);
    }

    public UserHomePage getUserHome() {
        DocumentBasePage.findElementWithTimeout(By.linkText((String)"HOME")).click();
        UserHomePage page = this.asPage(UserHomePage.class);
        return page.goToDashboard();
    }

    public WorkflowTabSubPage getWorkflow() {
        this.workflowLink.click();
        return this.asPage(WorkflowTabSubPage.class);
    }

    public WorkspacesContentTabSubPage getWorkspacesContentTab() {
        this.clickOnLinkIfNotSelected(this.contentTabLink);
        return this.asPage(WorkspacesContentTabSubPage.class);
    }

    public DocumentBasePage goToDocumentByBreadcrumb(String documentTitle) {
        this.breadcrumbForm.findElement(By.linkText((String)documentTitle)).click();
        return this.asPage(DocumentBasePage.class);
    }

    public AddToCollectionForm getAddToCollectionPopup() {
        this.addToCollectionUpperAction.click();
        Locator.waitUntilElementPresent(By.id((String)"fancybox-content"));
        return this.getWebFragment(By.id((String)"fancybox-content"), AddToCollectionForm.class);
    }

    public AddToCollectionForm getAddAllToCollectionPopup() {
        Locator.waitUntilGivenFunctionIgnoring(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return StringUtils.isBlank((String)driver.findElement(By.id((String)DocumentBasePage.ADD_ALL_TO_COLLECTION_ACTION_ID)).getAttribute("disabled"));
            }
        }, StaleElementReferenceException.class);
        this.driver.findElement(By.id((String)ADD_ALL_TO_COLLECTION_ACTION_ID)).click();
        Locator.waitUntilElementPresent(By.id((String)"fancybox-content"));
        return this.getWebFragment(By.id((String)"fancybox-content"), AddToCollectionForm.class);
    }

    public boolean isAddToCollectionUpperActionAvailable() {
        try {
            this.driver.findElement(By.id((String)ADD_TO_COLLECTION_UPPER_ACTION_ID));
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public void popupUserMenuActions() {
        this.userMenuActions.findElement(By.id((String)"nxw_userMenuActions_dropDownMenu")).click();
        Locator.waitUntilGivenFunctionIgnoring(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !DocumentBasePage.this.userMenuActions.findElement(By.xpath((String)"//ul[@class='actionSubList']")).getAttribute("style").equals("display: none;");
            }
        }, StaleElementReferenceException.class);
    }

    public DocumentBasePage swithToPersonalWorkspace() {
        this.popupUserMenuActions();
        this.driver.findElement(By.linkText((String)"Personal Workspace")).click();
        return this.asPage(DocumentBasePage.class);
    }

    public DocumentBasePage swithToDocumentBase() {
        this.popupUserMenuActions();
        this.driver.findElement(By.linkText((String)"Back to document base")).click();
        return this.asPage(DocumentBasePage.class);
    }

    public HomePage goToHomePage() {
        this.homePageLink.click();
        return this.asPage(HomePage.class);
    }

    public SearchPage goToSearchPage() {
        this.searchPageLink.click();
        return this.asPage(SearchPage.class);
    }

    public class UserNotConnectedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UserNotConnectedException(String username) {
            super("The user " + username + " is expected to be connected but isn't");
        }
    }
}

